/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.client.IDrawable;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class SameItemFilter
implements IFilter {
    public static final String ID = "refinedrelocation:same_item_filter";
    private boolean ignoreNBT = true;

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return tileEntity.getCapability(Capabilities.SORTING_INVENTORY).isPresent();
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        LazyOptional itemHandlerCap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        return (Boolean)itemHandlerCap.map(itemHandler -> {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack otherStack = itemHandler.getStackInSlot(i);
                if (otherStack.func_190926_b() || itemStack.func_77973_b() != otherStack.func_77973_b() || !this.ignoreNBT && !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)otherStack)) continue;
                return true;
            }
            return true;
        }).orElse((Object)false);
    }

    public INBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74757_a("IgnoreNBT", this.ignoreNBT);
        return compound;
    }

    public void deserializeNBT(INBT nbt) {
        CompoundNBT compound = (CompoundNBT)nbt;
        this.ignoreNBT = compound.func_74767_n("IgnoreNBT");
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:same_item_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:same_item_filter.description";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IDrawable getFilterIcon() {
        return GuiTextures.SAME_ITEM_FILTER_ICON;
    }
}

