/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocationUtils;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.api.container.ReturnCallback;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingInventory;
import net.blay09.mods.refinedrelocation.container.AddFilterContainer;
import net.blay09.mods.refinedrelocation.container.FilterContainer;
import net.blay09.mods.refinedrelocation.container.IRootFilterContainer;
import net.blay09.mods.refinedrelocation.container.ModContainers;
import net.blay09.mods.refinedrelocation.filter.RootFilter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public class RootFilterContainer
extends FilterContainer
implements IRootFilterContainer {
    public static final String KEY_ROOT_FILTER = "RootFilter";
    public static final String KEY_OPEN_ADD_FILTER = "OpenAddFilter";
    public static final String KEY_EDIT_FILTER = "EditFilter";
    public static final String KEY_DELETE_FILTER = "DeleteFilter";
    public static final String KEY_PRIORITY = "Priority";
    public static final String KEY_BLACKLIST = "Blacklist";
    public static final String KEY_BLACKLIST_INDEX = "FilterIndex";
    private final PlayerEntity entityPlayer;
    private final TileEntity tileEntity;
    private final IRootFilter rootFilter;
    private final int rootFilterIndex;
    private ReturnCallback returnCallback;
    private ISortingInventory sortingInventory;
    private int lastFilterCount = -1;
    private int lastPriority;
    private final boolean[] lastBlacklist = new boolean[3];

    public RootFilterContainer(int windowId, PlayerInventory playerInventory, TileEntity tileEntity, int rootFilterIndex) {
        super(ModContainers.rootFilter, windowId);
        this.entityPlayer = playerInventory.field_70458_d;
        this.tileEntity = tileEntity;
        this.rootFilter = (IRootFilter)RefinedRelocationUtils.getRootFilter(tileEntity, rootFilterIndex).orElseGet(RootFilter::new);
        this.rootFilterIndex = rootFilterIndex;
        this.sortingInventory = (ISortingInventory)tileEntity.getCapability(CapabilitySortingInventory.CAPABILITY).orElseGet(() -> Capabilities.getDefaultInstance(CapabilitySortingInventory.CAPABILITY));
        this.addPlayerInventory(playerInventory, 8, this.hasSortingInventory() ? 128 : 84);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.rootFilter.getFilterCount() != this.lastFilterCount) {
            this.syncFilterList();
            RefinedRelocationAPI.updateFilterPreview(this.entityPlayer, this.tileEntity, this.rootFilter);
        }
        for (int i = 0; i < this.lastBlacklist.length; ++i) {
            boolean nowBlacklist = this.rootFilter.isBlacklist(i);
            if (this.lastBlacklist[i] == nowBlacklist) continue;
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a(KEY_BLACKLIST_INDEX, i);
            compound.func_74757_a(KEY_BLACKLIST, nowBlacklist);
            RefinedRelocationAPI.syncContainerValue(KEY_BLACKLIST, compound, (Iterable<IContainerListener>)this.field_75149_d);
            this.lastBlacklist[i] = nowBlacklist;
        }
        if (this.sortingInventory.getPriority() != this.lastPriority) {
            RefinedRelocationAPI.syncContainerValue(KEY_PRIORITY, this.sortingInventory.getPriority(), (Iterable<IContainerListener>)this.field_75149_d);
            this.lastPriority = this.sortingInventory.getPriority();
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        RefinedRelocationAPI.updateFilterPreview(player, this.tileEntity, this.rootFilter);
        return itemStack;
    }

    private void syncFilterList() {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_218657_a(KEY_ROOT_FILTER, this.rootFilter.serializeNBT());
        RefinedRelocationAPI.syncContainerValue(KEY_ROOT_FILTER, tagCompound, (Iterable<IContainerListener>)this.field_75149_d);
        this.lastFilterCount = this.rootFilter.getFilterCount();
        for (int i = 0; i < this.lastBlacklist.length; ++i) {
            this.lastBlacklist[i] = this.rootFilter.isBlacklist(i);
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (index < 27 ? !this.func_75135_a(slotStack, 27, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        switch (message.getKey()) {
            case "OpenAddFilter": {
                INamedContainerProvider containerProvider = new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent("container.refinedrelocation:add_filter", new Object[0]);
                    }

                    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                        return new AddFilterContainer(windowId, playerInventory, RootFilterContainer.this.tileEntity, RootFilterContainer.this.rootFilterIndex);
                    }
                };
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)this.entityPlayer), (INamedContainerProvider)containerProvider, it -> {
                    it.func_179255_a(this.tileEntity.func_174877_v());
                    it.writeByte(this.rootFilterIndex);
                });
                break;
            }
            case "EditFilter": {
                INamedContainerProvider filterConfig;
                int index = message.getIntValue();
                if (index < 0 || index >= this.rootFilter.getFilterCount()) {
                    return;
                }
                IFilter filter = this.rootFilter.getFilter(index);
                if (filter == null || (filterConfig = filter.getConfiguration(this.entityPlayer, this.tileEntity, this.rootFilterIndex)) == null) break;
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)this.entityPlayer), (INamedContainerProvider)filterConfig, it -> {
                    it.func_179255_a(this.tileEntity.func_174877_v());
                    it.writeByte(this.rootFilterIndex);
                    it.writeByte(index);
                });
                break;
            }
            case "DeleteFilter": {
                int index = message.getIntValue();
                if (index < 0 || index >= this.rootFilter.getFilterCount()) {
                    return;
                }
                this.rootFilter.removeFilter(index);
                this.tileEntity.func_70296_d();
                break;
            }
            case "Priority": {
                int value = message.getIntValue();
                if (value < -999 || value > 999) {
                    return;
                }
                this.sortingInventory.setPriority(value);
                this.tileEntity.func_70296_d();
                break;
            }
            case "Blacklist": {
                CompoundNBT tagCompound = message.getNBTValue();
                int index = tagCompound.func_74762_e(KEY_BLACKLIST_INDEX);
                if (index < 0 || index >= this.rootFilter.getFilterCount()) {
                    return;
                }
                this.rootFilter.setIsBlacklist(index, tagCompound.func_74767_n(KEY_BLACKLIST));
                this.tileEntity.func_70296_d();
                RefinedRelocationAPI.updateFilterPreview(this.entityPlayer, this.tileEntity, this.rootFilter);
                break;
            }
        }
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        switch (message.getKey()) {
            case "RootFilter": {
                this.rootFilter.deserializeNBT((INBT)message.getNBTValue().func_74775_l(KEY_ROOT_FILTER));
                break;
            }
            case "Priority": {
                this.sortingInventory.setPriority(message.getIntValue());
                break;
            }
            case "Blacklist": {
                CompoundNBT compound = message.getNBTValue();
                this.rootFilter.setIsBlacklist(compound.func_74762_e(KEY_BLACKLIST_INDEX), compound.func_74767_n(KEY_BLACKLIST));
            }
        }
    }

    @Override
    public IRootFilter getRootFilter() {
        return this.rootFilter;
    }

    public boolean hasSortingInventory() {
        return this.tileEntity.getCapability(CapabilitySortingInventory.CAPABILITY).isPresent();
    }

    public ISortingInventory getSortingInventory() {
        return this.sortingInventory;
    }

    @Nullable
    public ReturnCallback getReturnCallback() {
        return this.returnCallback;
    }

    public RootFilterContainer setReturnCallback(@Nullable ReturnCallback returnCallback) {
        this.returnCallback = returnCallback;
        return this;
    }

    public boolean canReturnFromFilter() {
        return this.tileEntity instanceof INamedContainerProvider;
    }

    @Override
    public int getRootFilterIndex() {
        return this.rootFilterIndex;
    }
}

