/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.base;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.blay09.mods.refinedrelocation.client.gui.base.ITickableElement;
import net.blay09.mods.refinedrelocation.client.gui.base.ITooltipElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.MultiLineTextFieldWidget;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;

public abstract class ModContainerScreen<T extends Container>
extends ContainerScreen<T> {
    protected final T field_147002_h;
    protected boolean shouldKeyRepeat;
    private List<IGuiEventListener> saneChildren = new ArrayList<IGuiEventListener>();

    public ModContainerScreen(T container, PlayerInventory playerInventory, ITextComponent displayName) {
        super(container, playerInventory, displayName);
        this.field_147002_h = container;
    }

    @OverridingMethodsMustInvokeSuper
    protected void init() {
        super.init();
        if (this.shouldKeyRepeat) {
            this.minecraft.field_195559_v.func_197967_a(true);
        }
    }

    public boolean onGuiAboutToClose() {
        return true;
    }

    @OverridingMethodsMustInvokeSuper
    public void onClose() {
        super.onClose();
        if (this.shouldKeyRepeat) {
            this.minecraft.field_195559_v.func_197967_a(false);
        }
    }

    public void tick() {
        super.tick();
        for (IGuiEventListener child : this.saneChildren) {
            if (child instanceof MultiLineTextFieldWidget) {
                ((MultiLineTextFieldWidget)child).func_146178_a();
                continue;
            }
            if (!(child instanceof ITickableElement)) continue;
            ((ITickableElement)child).tick();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (int i = this.saneChildren.size() - 1; i >= 0; --i) {
            IGuiEventListener child = this.saneChildren.get(i);
            if (!(child instanceof ITooltipElement) || !child.isMouseOver((double)mouseX, (double)mouseY)) continue;
            ArrayList<String> tooltip = new ArrayList<String>();
            ((ITooltipElement)child).addTooltip(tooltip);
            this.renderTooltip(tooltip, mouseX, mouseY);
            break;
        }
    }

    protected <V extends Widget> V addButton(V button) {
        this.buttons.add(button);
        this.saneChildren.add((IGuiEventListener)button);
        return button;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifier) {
        IGuiEventListener focused;
        if (keyCode == 256) {
            this.getMinecraft().field_71439_g.func_71053_j();
        }
        if ((focused = this.getFocused()) instanceof TextFieldWidget && (focused.keyPressed(keyCode, scanCode, modifier) || ((TextFieldWidget)focused).func_212955_f())) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifier);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (IGuiEventListener listener : this.saneChildren) {
            listener.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (int i = this.saneChildren.size() - 1; i >= 0; --i) {
            IGuiEventListener listener = this.saneChildren.get(i);
            if (!listener.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double button) {
        for (int i = this.saneChildren.size() - 1; i >= 0; --i) {
            IGuiEventListener listener = this.saneChildren.get(i);
            if (!listener.mouseScrolled(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, button);
    }

    public boolean isTopMostElement(Widget widget, double mouseX, double mouseY) {
        for (int i = this.saneChildren.size() - 1; i >= 0; --i) {
            IGuiEventListener listener = this.saneChildren.get(i);
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener == widget;
        }
        return false;
    }
}

