/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.solidifier;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.block.AbstractFluidMachineTileEntity;
import net.silentchaos512.mechanisms.block.solidifier.SolidifierContainer;
import net.silentchaos512.mechanisms.crafting.recipe.SolidifyingRecipe;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.InventoryUtils;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;

public class SolidifierTileEntity
extends AbstractFluidMachineTileEntity<SolidifyingRecipe> {
    public static final int FIELDS_COUNT = 9;
    public static final int TANK_CAPACITY = 4000;
    public static final int ENERGY_PER_TICK = 50;

    public SolidifierTileEntity() {
        super(ModTileEntities.solidifier, 3, 1, 4000, MachineTier.STANDARD);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.tryFillTank();
        super.func_73660_a();
    }

    private void tryFillTank() {
        ItemStack input = this.func_70301_a(0);
        if (input.func_190926_b()) {
            return;
        }
        FluidStack fluidStack = IFluidContainer.getBucketOrContainerFluid(input);
        if (this.canAcceptFluidContainer(input, fluidStack)) {
            this.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            ItemStack containerItem = input.getContainerItem();
            input.func_190918_g(1);
            ItemStack output = this.func_70301_a(1);
            if (output.func_190926_b()) {
                this.func_70299_a(1, containerItem);
            } else {
                output.func_190917_f(1);
            }
        }
    }

    private boolean canAcceptFluidContainer(ItemStack input, FluidStack fluid) {
        ItemStack output = this.func_70301_a(1);
        return !(fluid.isEmpty() || !this.isFluidValid(0, fluid) || this.fill(fluid, IFluidHandler.FluidAction.SIMULATE) != 1000 || !output.func_190926_b() && !InventoryUtils.canItemsStack(input.getContainerItem(), output) || !output.func_190926_b() && output.func_190916_E() >= output.func_77976_d());
    }

    @Override
    protected int getEnergyUsedPerTick() {
        return 50;
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[]{2};
    }

    @Override
    protected int getInputTanks() {
        return 1;
    }

    @Override
    protected int getOutputTanks() {
        return 0;
    }

    @Override
    @Nullable
    public SolidifyingRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(SolidifyingRecipe.RECIPE_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
    }

    @Override
    protected int getProcessTime(SolidifyingRecipe recipe) {
        return recipe.getProcessTime();
    }

    @Override
    protected Collection<ItemStack> getProcessResults(SolidifyingRecipe recipe) {
        return Collections.singletonList(recipe.getCraftingResult(this));
    }

    @Override
    protected Collection<FluidStack> getFluidResults(SolidifyingRecipe recipe) {
        return recipe.getFluidOutputs();
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 && InventoryUtils.isFilledFluidContainer(stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1 || index == 2;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "solidifier", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new SolidifierContainer(id, player, this, this.fields);
    }
}

