/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block;

import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;
import net.silentchaos512.mechanisms.util.MachineTier;

public abstract class AbstractMachineBlock
extends AbstractFurnaceBlock {
    protected final MachineTier tier;

    public AbstractMachineBlock(MachineTier tier, Block.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    protected void func_220089_a(World worldIn, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof INamedContainerProvider) {
            player.func_213829_a((INamedContainerProvider)tileEntity);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof AbstractMachineBaseTileEntity) {
            return AbstractMachineBlock.calcRedstoneFromInventory((AbstractMachineBaseTileEntity)tileEntity);
        }
        return super.func_180641_l(blockState, worldIn, pos);
    }

    private static int calcRedstoneFromInventory(AbstractMachineBaseTileEntity inv) {
        int slotsFilled = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < inv.func_70302_i_() - inv.getMachineTier().getUpgradeSlots(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            fillRatio += (float)itemstack.func_190916_E() / (float)Math.min(inv.func_70297_j_(), itemstack.func_77976_d());
            ++slotsFilled;
        }
        return MathHelper.func_76141_d((float)((fillRatio /= (float)inv.func_70302_i_()) * 14.0f)) + (slotsFilled > 0 ? 1 : 0);
    }
}

