/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.tools.client.GlowArmor;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.ToolsLang;
import mekanism.tools.common.material.BaseMekanismMaterial;
import mekanism.tools.common.registries.ToolsItems;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMekanismArmor
extends ArmorItem
implements IHasRepairType {
    private final BaseMekanismMaterial material;

    public ItemMekanismArmor(BaseMekanismMaterial material, EquipmentSlotType slot) {
        super((IArmorMaterial)material, slot, ItemDeferredRegister.getMekBaseProperties());
        this.material = material;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)ToolsLang.HP.translate(new Object[]{stack.func_77958_k() - stack.func_77952_i()}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        if (itemStack.func_77973_b() == ToolsItems.REFINED_GLOWSTONE_HELMET.getItem() || itemStack.func_77973_b() == ToolsItems.REFINED_GLOWSTONE_CHESTPLATE.getItem() || itemStack.func_77973_b() == ToolsItems.REFINED_GLOWSTONE_LEGGINGS.getItem() || itemStack.func_77973_b() == ToolsItems.REFINED_GLOWSTONE_BOOTS.getItem()) {
            return GlowArmor.getGlow(armorSlot);
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.func_200880_d().func_200898_c();
    }

    public int func_200881_e() {
        return this.func_200880_d().func_200902_b(this.func_185083_B_());
    }

    public float getToughness() {
        return this.func_200880_d().func_200901_e();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_200896_a(this.func_185083_B_());
    }

    public boolean func_77645_m() {
        return this.material.func_200896_a(this.func_185083_B_()) > 0;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType slot) {
        HashMultimap attributes = HashMultimap.create();
        if (slot == this.func_185083_B_()) {
            UUID modifier = field_185084_n[slot.func_188454_b()];
            attributes.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.func_200881_e(), AttributeModifier.Operation.ADDITION));
            attributes.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.getToughness(), AttributeModifier.Operation.ADDITION));
        }
        return attributes;
    }
}

