/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen.structure.processor;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Random;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.spawner.AbstractSpawner;

public class BigDungeonSpawnerProcessor
extends StructureProcessor {
    private static final IStructureProcessorType TYPE = (IStructureProcessorType)Registry.func_218325_a((Registry)Registry.field_218364_E, (String)"quark:big_dungeon_spawner", BigDungeonSpawnerProcessor::new);

    public BigDungeonSpawnerProcessor() {
    }

    public BigDungeonSpawnerProcessor(Dynamic<?> dyn) {
        this();
    }

    public Template.BlockInfo process(IWorldReader worldReaderIn, BlockPos pos, Template.BlockInfo p_215194_3_, Template.BlockInfo blockInfo, PlacementSettings placementSettingsIn, Template template) {
        if (blockInfo.field_186243_b.func_177230_c() instanceof SpawnerBlock) {
            Random rand = placementSettingsIn.func_189947_a(blockInfo.field_186242_a);
            TileEntity tile = TileEntity.func_203403_c((CompoundNBT)blockInfo.field_186244_c);
            if (tile instanceof MobSpawnerTileEntity) {
                MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)tile;
                AbstractSpawner logic = spawner.func_145881_a();
                double val = rand.nextDouble();
                if (val > 0.95) {
                    logic.func_200876_a(EntityType.field_200797_k);
                } else if (val > 0.5) {
                    logic.func_200876_a(EntityType.field_200741_ag);
                } else {
                    logic.func_200876_a(EntityType.field_200725_aD);
                }
                CompoundNBT nbt = new CompoundNBT();
                spawner.func_189515_b(nbt);
                return new Template.BlockInfo(blockInfo.field_186242_a, blockInfo.field_186243_b, nbt);
            }
        }
        return blockInfo;
    }

    protected IStructureProcessorType func_215192_a() {
        return TYPE;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return new Dynamic(ops);
    }
}

