/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.Food;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.client.module.ImprovedTooltipsModule;
import vazkii.quark.client.tooltip.TooltipUtils;

public class FoodTooltips {
    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(ItemTooltipEvent event) {
        Food food;
        if (event.getItemStack().func_222117_E() && (food = event.getItemStack().func_77973_b().func_219967_s()) != null) {
            int pips = food.func_221466_a();
            int len = (int)Math.ceil((double)pips / (double)ImprovedTooltipsModule.foodDivisor);
            StringBuilder s = new StringBuilder(" ");
            for (int i = 0; i < len; ++i) {
                s.append("  ");
            }
            StringTextComponent spaces = new StringTextComponent(s.toString());
            List tooltip = event.getToolTip();
            if (tooltip.isEmpty()) {
                tooltip.add(spaces);
            } else {
                tooltip.add(1, spaces);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderTooltip(RenderTooltipEvent.PostText event) {
        Food food;
        if (event.getStack().func_222117_E() && (food = event.getStack().func_77973_b().func_219967_s()) != null) {
            RenderSystem.pushMatrix();
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(ForgeIngameGui.GUI_ICONS_LOCATION);
            int pips = food.func_221466_a();
            boolean poison = false;
            for (Pair effect : food.func_221464_f()) {
                if (effect.getLeft() == null || ((EffectInstance)effect.getLeft()).func_188419_a() == null || ((EffectInstance)effect.getLeft()).func_188419_a().func_220303_e() != EffectType.HARMFUL) continue;
                poison = true;
                break;
            }
            int count = (int)Math.ceil((double)pips / (double)ImprovedTooltipsModule.foodDivisor);
            int y = TooltipUtils.shiftTextByLines(event.getLines(), event.getY() + 10);
            for (int i = 0; i < count; ++i) {
                int x = event.getX() + i * 9 - 1;
                int u = 16;
                if (poison) {
                    u += 117;
                }
                int v = 27;
                AbstractGui.blit((int)x, (int)y, (float)u, (float)v, (int)9, (int)9, (int)256, (int)256);
                u = 52;
                if (pips % 2 != 0 && i == 0) {
                    u += 9;
                }
                if (poison) {
                    u += 36;
                }
                AbstractGui.blit((int)x, (int)y, (float)u, (float)v, (int)9, (int)9, (int)256, (int)256);
            }
            RenderSystem.popMatrix();
        }
    }
}

