/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.beans.ConstructorProperties;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.SizeValidators;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class MinimumSizeValidator
implements ISizeValidator {
    private final Vec3i minimumSize;

    @Override
    public ITextComponent isSizeValid(Vec3i size) {
        if (SizeValidators.compareVec3i(size, this.getMinimumSize()) >= 0) {
            return null;
        }
        return new TranslationTextComponent("multiblock.cyclopscore.error.size.min", new Object[]{LocationHelpers.toCompactString(size), LocationHelpers.toCompactString(this.getMinimumSize())});
    }

    @ConstructorProperties(value={"minimumSize"})
    public MinimumSizeValidator(Vec3i minimumSize) {
        this.minimumSize = minimumSize;
    }

    public Vec3i getMinimumSize() {
        return this.minimumSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinimumSizeValidator)) {
            return false;
        }
        MinimumSizeValidator other = (MinimumSizeValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vec3i this$minimumSize = this.getMinimumSize();
        Vec3i other$minimumSize = other.getMinimumSize();
        return !(this$minimumSize == null ? other$minimumSize != null : !this$minimumSize.equals(other$minimumSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinimumSizeValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vec3i $minimumSize = this.getMinimumSize();
        result = result * 59 + ($minimumSize == null ? 0 : $minimumSize.hashCode());
        return result;
    }

    public String toString() {
        return "MinimumSizeValidator(minimumSize=" + this.getMinimumSize() + ")";
    }
}

