/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.advancement.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;

public abstract class BaseCriterionTrigger<D, T extends ICriterionInstanceTestable<D>>
implements ICriterionTrigger<T> {
    private final Map<PlayerAdvancements, Listeners<D, T>> listeners = Maps.newHashMap();
    private final ResourceLocation id;

    protected BaseCriterionTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        Listeners<D, T> listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        Listeners<D, T> listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public void trigger(ServerPlayerEntity player, D criterionData) {
        Listeners<D, T> listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(player, criterionData);
        }
    }

    static class Listeners<D, T extends ICriterionInstanceTestable<D>> {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<T>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<T> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<T> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ServerPlayerEntity player, D criterionData) {
            List list = null;
            for (ICriterionTrigger.Listener<T> listener : this.listeners) {
                if (!((ICriterionInstanceTestable)listener.func_192158_a()).test(player, criterionData)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }
}

