/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import technicianlp.reauth.AuthHelper;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.gui.ScreenAuth;

@Mod.EventBusSubscriber(modid="reauth", value={Dist.CLIENT})
public final class EventHandler {
    private static final Field disconnectMessage = ObfuscationReflectionHelper.findField(DisconnectedScreen.class, (String)"field_146304_f");
    private static final Field previousScreen = ObfuscationReflectionHelper.findField(DisconnectedScreen.class, (String)"field_146307_h");

    @SubscribeEvent
    public static void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen screen = event.getGui();
        if (screen instanceof MultiplayerScreen) {
            event.addWidget((Widget)new Button(5, 5, 100, 20, I18n.func_135052_a((String)"reauth.gui.button", (Object[])new Object[0]), b -> EventHandler.openAuthenticationScreen(screen)));
        } else if (screen instanceof MainMenuScreen) {
            event.addWidget((Widget)new Button(-50, -50, 20, 20, I18n.func_135052_a((String)"reauth.gui.button", (Object[])new Object[0]), b -> EventHandler.openAuthenticationScreen(screen)));
        } else if (screen instanceof DisconnectedScreen && "connect.failed".equals(EventHandler.getTranslationKey(screen.getTitle())) && EventHandler.getTranslationKey(ReAuth.getField(disconnectMessage, screen)).startsWith("disconnect.loginFailed")) {
            Widget menu = (Widget)event.getWidgetList().get(0);
            event.addWidget((Widget)new Button(menu.x, menu.y + 25, 200, 20, I18n.func_135052_a((String)"reauth.open", (Object[])new Object[0]), b -> EventHandler.openAuthenticationScreen((Screen)ReAuth.getField(previousScreen, screen))));
        }
    }

    private static void openAuthenticationScreen(Screen parent) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ScreenAuth(parent));
    }

    private static String getTranslationKey(Object component) {
        if (component instanceof TranslationTextComponent) {
            return ((TranslationTextComponent)component).func_150268_i();
        }
        return "";
    }

    @SubscribeEvent
    public static void onDrawGui(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (e.getGui() instanceof MultiplayerScreen) {
            AuthHelper.SessionStatus state = ReAuth.auth.getSessionStatus(false);
            e.getGui().drawString(e.getGui().getMinecraft().field_71466_p, I18n.func_135052_a((String)state.getTranslationKey(), (Object[])new Object[0]), 110, 10, -1);
        }
    }

    @SubscribeEvent
    public static void onOpenGui(GuiOpenEvent e) {
        if (e.getGui() instanceof MultiplayerScreen && Minecraft.func_71410_x().field_71462_r instanceof MultiplayerScreen && Screen.hasShiftDown()) {
            ReAuth.auth.getSessionStatus(true);
        }
    }
}

