/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IEntityReader;
import net.minecraft.world.border.WorldBorder;

public class LithiumEntityCollisions {
    public static Stream<VoxelShape> getBlockCollisions(final ICollisionReader world, final Entity entity, final AxisAlignedBB entityBox) {
        int minX = MathHelper.func_76128_c((double)(entityBox.field_72340_a - 1.0E-7)) - 1;
        int maxX = MathHelper.func_76128_c((double)(entityBox.field_72336_d + 1.0E-7)) + 1;
        int minY = MathHelper.func_76128_c((double)(entityBox.field_72338_b - 1.0E-7)) - 1;
        int maxY = MathHelper.func_76128_c((double)(entityBox.field_72337_e + 1.0E-7)) + 1;
        int minZ = MathHelper.func_76128_c((double)(entityBox.field_72339_c - 1.0E-7)) - 1;
        int maxZ = MathHelper.func_76128_c((double)(entityBox.field_72334_f + 1.0E-7)) + 1;
        final ISelectionContext context = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        final CubeCoordinateIterator cuboidIt = new CubeCoordinateIterator(minX, minY, minZ, maxX, maxY, maxZ);
        final BlockPos.Mutable pos = new BlockPos.Mutable();
        final VoxelShape entityShape = VoxelShapes.func_197881_a((AxisAlignedBB)entityBox);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){
            boolean skipWorldBorderCheck;
            {
                super(x0, x1);
                this.skipWorldBorderCheck = entity == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> consumer) {
                if (!this.skipWorldBorderCheck) {
                    this.skipWorldBorderCheck = true;
                    WorldBorder border = world.func_175723_af();
                    boolean isInsideBorder = LithiumEntityCollisions.isBoxFullyWithinWorldBorder(border, entity.func_174813_aQ().func_186664_h(1.0E-7));
                    boolean isCrossingBorder = LithiumEntityCollisions.isBoxFullyWithinWorldBorder(border, entity.func_174813_aQ().func_186662_g(1.0E-7));
                    if (!isInsideBorder && isCrossingBorder) {
                        consumer.accept((VoxelShape)border.func_222521_a());
                        return true;
                    }
                }
                while (cuboidIt.func_218301_a()) {
                    VoxelShape blockShape;
                    IBlockReader chunk;
                    int x = cuboidIt.func_218304_b();
                    int y = cuboidIt.func_218302_c();
                    int z = cuboidIt.func_218303_d();
                    int edgesHit = cuboidIt.func_223473_e();
                    if (edgesHit == 3 || (chunk = world.func_225522_c_(x >> 4, z >> 4)) == null) continue;
                    pos.func_181079_c(x, y, z);
                    BlockState state = chunk.func_180495_p((BlockPos)pos);
                    if (edgesHit == 1 && !state.func_215704_f() || edgesHit == 2 && state.func_177230_c() != Blocks.field_196603_bb || (blockShape = state.func_215685_b((IBlockReader)world, (BlockPos)pos, context)) == VoxelShapes.func_197880_a()) continue;
                    if (blockShape == VoxelShapes.func_197868_b()) {
                        if (!entityBox.func_186668_a((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0)) continue;
                        consumer.accept((VoxelShape)blockShape.func_197751_a((double)x, (double)y, (double)z));
                        return true;
                    }
                    VoxelShape shape = blockShape.func_197751_a((double)x, (double)y, (double)z);
                    if (!VoxelShapes.func_197879_c((VoxelShape)shape, (VoxelShape)entityShape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                    consumer.accept((VoxelShape)shape);
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static boolean isBoxFullyWithinWorldBorder(WorldBorder border, AxisAlignedBB box) {
        double wboxMinX = Math.floor(border.func_177726_b());
        double wboxMinZ = Math.floor(border.func_177736_c());
        double wboxMaxX = Math.ceil(border.func_177728_d());
        double wboxMaxZ = Math.ceil(border.func_177733_e());
        return box.field_72340_a >= wboxMinX && box.field_72340_a < wboxMaxX && box.field_72339_c >= wboxMinZ && box.field_72339_c < wboxMaxZ && box.field_72336_d >= wboxMinX && box.field_72336_d < wboxMaxX && box.field_72334_f >= wboxMinZ && box.field_72334_f < wboxMaxZ;
    }

    public static Stream<VoxelShape> getEntityCollisions(IEntityReader view, Entity entity, AxisAlignedBB box, Set<Entity> excluded) {
        if (box.func_72320_b() < 1.0E-7) {
            return Stream.empty();
        }
        AxisAlignedBB selection = box.func_186662_g(1.0E-7);
        List entities = view.func_72839_b(entity, selection);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (Entity otherEntity : entities) {
            AxisAlignedBB otherEntityHardBox;
            if (!excluded.isEmpty() && excluded.contains(otherEntity) || entity != null && entity.func_184223_x(otherEntity)) continue;
            AxisAlignedBB otherEntityBox = otherEntity.func_70046_E();
            if (otherEntityBox != null && selection.func_72326_a(otherEntityBox)) {
                shapes.add(VoxelShapes.func_197881_a((AxisAlignedBB)otherEntityBox));
            }
            if (entity == null || (otherEntityHardBox = entity.func_70114_g(otherEntity)) == null || !selection.func_72326_a(otherEntityHardBox)) continue;
            shapes.add(VoxelShapes.func_197881_a((AxisAlignedBB)otherEntityHardBox));
        }
        return shapes.stream();
    }
}

