/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.tracker.nearby;

import java.util.HashSet;
import java.util.Set;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityListener;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;

public class NearbyEntityTracker<T extends LivingEntity>
implements NearbyEntityListener {
    private final Class<T> clazz;
    private final LivingEntity self;
    private final int rangeC;
    private final float rangeSq;
    private final Set<T> nearby = new HashSet<T>();

    public NearbyEntityTracker(Class<T> clazz, LivingEntity self, float range) {
        this.clazz = clazz;
        this.self = self;
        this.rangeSq = range * range;
        this.rangeC = MathHelper.func_154354_b((int)MathHelper.func_76123_f((float)range), (int)16) >> 4;
    }

    @Override
    public int getChunkRange() {
        return this.rangeC;
    }

    @Override
    public void onEntityEnteredRange(LivingEntity entity) {
        if (!this.clazz.isInstance(entity)) {
            return;
        }
        this.nearby.add(entity);
    }

    @Override
    public void onEntityLeftRange(LivingEntity entity) {
        if (this.nearby.isEmpty() || !this.clazz.isInstance(entity)) {
            return;
        }
        this.nearby.remove(entity);
    }

    public T getClosestEntity() {
        double x = this.self.func_226277_ct_();
        double y = this.self.func_226278_cu_();
        double z = this.self.func_226281_cx_();
        LivingEntity nearest = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (LivingEntity entity : this.nearby) {
            double distance = entity.func_70092_e(x, y, z);
            if (!(distance < nearestDistance)) continue;
            nearest = entity;
            nearestDistance = distance;
        }
        if (nearestDistance <= (double)this.rangeSq) {
            return (T)nearest;
        }
        return null;
    }
}

