/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.network.SyncGearPartsPacket;
import net.silentchaos512.gear.parts.PartSerializers;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class PartManager
implements IResourceManagerReloadListener {
    public static final PartManager INSTANCE = new PartManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"PartManager");
    private static final String DATA_PATH = "silentgear_parts";
    private static final String DATA_PATH_OLD = "silentgear/parts";
    private static final Map<ResourceLocation, IGearPart> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static int highestMainPartTier = 0;
    private static final Collection<ResourceLocation> ERROR_LIST = new ArrayList<ResourceLocation>();

    private PartManager() {
    }

    public static int getHighestMainPartTier() {
        return highestMainPartTier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection<ResourceLocation> resources = PartManager.getAllResources(resourceManager);
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IGearPart> map = MAP;
        synchronized (map) {
            MAP.clear();
            ERROR_LIST.clear();
            SilentGear.LOGGER.info(MARKER, "Reloading part files");
            for (ResourceLocation id : resources) {
                String path = id.func_110623_a().substring(DATA_PATH.length() + 1, id.func_110623_a().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                try {
                    IResource iresource = resourceManager.func_199002_a(id);
                    Throwable throwable = null;
                    try {
                        JsonObject json;
                        if (SilentGear.LOGGER.isTraceEnabled()) {
                            SilentGear.LOGGER.trace(MARKER, "Found likely part file: {}, trying to read as part {}", (Object)id, (Object)name);
                        }
                        if ((json = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class)) == null) {
                            SilentGear.LOGGER.error(MARKER, "Could not load part {} as it's null or empty", (Object)name);
                            continue;
                        }
                        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                            SilentGear.LOGGER.info("Skipping loading gear part {} as it's conditions were not met", (Object)name);
                            continue;
                        }
                        IGearPart part = PartSerializers.deserialize(name, json);
                        PartManager.addPart(part);
                        highestMainPartTier = Math.max(highestMainPartTier, part.getTier());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error(MARKER, "Parsing error loading gear part {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(name);
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error(MARKER, "Could not read gear part {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(name);
                }
            }
            SilentGear.LOGGER.info(MARKER, "Registered {} parts", (Object)MAP.size());
        }
    }

    private static Collection<ResourceLocation> getAllResources(IResourceManager resourceManager) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.addAll(resourceManager.func_199003_a(DATA_PATH, s -> s.endsWith(".json")));
        list.addAll(resourceManager.func_199003_a(DATA_PATH_OLD, s -> s.endsWith(".json")));
        return list;
    }

    private static void addPart(IGearPart part) {
        if (MAP.containsKey(part.getId())) {
            throw new IllegalStateException("Duplicate gear part " + part.getId());
        }
        MAP.put(part.getId(), part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IGearPart> getValues() {
        Map<ResourceLocation, IGearPart> map = MAP;
        synchronized (map) {
            return MAP.values();
        }
    }

    public static List<IGearPart> getPartsOfType(PartType type) {
        return PartManager.getValues().stream().filter(part -> part.getType() == type).collect(Collectors.toList());
    }

    public static Collection<IGearPart> getMains() {
        return PartManager.getPartsOfType(PartType.MAIN);
    }

    public static Collection<IGearPart> getRods() {
        return PartManager.getPartsOfType(PartType.ROD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IGearPart get(ResourceLocation id) {
        Map<ResourceLocation, IGearPart> map = MAP;
        synchronized (map) {
            return MAP.get(id);
        }
    }

    @Nullable
    public static IGearPart get(String id) {
        ResourceLocation partId = ResourceLocation.func_208304_a((String)id);
        return partId != null ? PartManager.get(partId) : null;
    }

    @Nullable
    public static IGearPart from(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (IGearPart part : PartManager.getValues()) {
            if (!part.getMaterials().test(stack)) continue;
            return part;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static IGearPart tryGetFallback(PartType type) {
        return type.getFallbackPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handlePartSyncPacket(SyncGearPartsPacket packet, Supplier<NetworkEvent.Context> context) {
        Map<ResourceLocation, IGearPart> map = MAP;
        synchronized (map) {
            ImmutableMap oldParts = ImmutableMap.copyOf(MAP);
            MAP.clear();
            packet.getParts().forEach(arg_0 -> PartManager.lambda$handlePartSyncPacket$3((Map)oldParts, arg_0));
            SilentGear.LOGGER.info("Read {} parts from server", (Object)MAP.size());
        }
        context.get().setPacketHandled(true);
    }

    public static Collection<ITextComponent> getErrorMessages(ServerPlayerEntity player) {
        if (!ERROR_LIST.isEmpty()) {
            String listStr = ERROR_LIST.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            return ImmutableList.of((Object)new StringTextComponent("[Silent Gear] The following gear parts failed to load, check your log file:").func_211708_a(TextFormatting.RED), (Object)new StringTextComponent(listStr));
        }
        return ImmutableList.of();
    }

    private static /* synthetic */ void lambda$handlePartSyncPacket$3(Map oldParts, IGearPart part) {
        part.retainData((IGearPart)oldParts.get(part.getId()));
        MAP.put(part.getId(), part);
    }
}

