/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.utils.EnumUtils;
import org.apache.commons.lang3.NotImplementedException;

public class StatInstance {
    public static final StatInstance ZERO = new StatInstance(0.0f, Operation.ADD);
    private final float value;
    private final Operation op;

    @Deprecated
    public StatInstance(String id, float value, Operation op) {
        this.value = value;
        this.op = op;
    }

    public StatInstance(float value, Operation op) {
        this.value = value;
        this.op = op;
    }

    public StatInstance copy() {
        return new StatInstance(this.value, this.op);
    }

    @Deprecated
    public String getId() {
        return "DEPRECATED";
    }

    public float getValue() {
        return this.value;
    }

    public Operation getOp() {
        return this.op;
    }

    public static StatInstance makeBaseMod(float value) {
        return new StatInstance("_base_mod", value, Operation.ADD);
    }

    public static StatInstance makeGearMod(float multi) {
        return new StatInstance("_gear_mod", multi, Operation.MUL1);
    }

    @Deprecated
    public StatInstance copyAppendId(String append) {
        return this.copyWithNewId(this.getId() + append);
    }

    @Deprecated
    public StatInstance copyWithNewId(String newId) {
        return new StatInstance(newId, this.value, this.op);
    }

    public String formattedString(@Nonnegative int decimalPlaces, boolean addColor) {
        String format = "%s" + "%." + decimalPlaces + "f" + "%s";
        switch (this.op) {
            case ADD: {
                TextFormatting color = this.getFormattedColor(this.value, 0.0f, addColor);
                return color + String.format(format, this.value < 0.0f ? "" : "+", Float.valueOf(this.value), "");
            }
            case AVG: {
                return String.format(format, "", Float.valueOf(this.value), "");
            }
            case MAX: {
                return String.format(format, "^", Float.valueOf(this.value), "");
            }
            case MUL1: {
                int percent = Math.round(100.0f * this.value);
                TextFormatting color = this.getFormattedColor(percent, 0.0f, addColor);
                format = "%s%d%%";
                return color + String.format(format, percent < 0 ? "" : "+", percent);
            }
            case MUL2: {
                float val = 1.0f + this.value;
                TextFormatting color = this.getFormattedColor(val, 1.0f, addColor);
                return color + String.format(format, "x", Float.valueOf(val), "");
            }
        }
        throw new NotImplementedException("Unknown operation: " + (Object)((Object)this.op));
    }

    private TextFormatting getFormattedColor(float val, float whiteVal, boolean addColor) {
        if (!addColor) {
            return TextFormatting.WHITE;
        }
        return val < whiteVal ? TextFormatting.RED : (val == whiteVal ? TextFormatting.WHITE : TextFormatting.GREEN);
    }

    public boolean shouldList(IGearPart part, ItemStat stat, boolean advanced) {
        return advanced || this.value != 0.0f || part.getType() == PartType.MAIN && stat == ItemStats.HARVEST_LEVEL;
    }

    public String toString() {
        return String.format("StatInstance{value=%f, op=%s}", new Object[]{Float.valueOf(this.value), this.op});
    }

    public static StatInstance read(IGearPart part, ItemStat stat, JsonElement json) {
        if (json.isJsonPrimitive()) {
            return new StatInstance(json.getAsFloat(), part.getDefaultStatOperation(stat));
        }
        if (json.isJsonObject()) {
            JsonObject jsonObj = json.getAsJsonObject();
            StatInstance result = StatInstance.readShorthandObject(part, stat, jsonObj);
            if (result != null) {
                return result;
            }
            float value = JSONUtils.func_151221_a((JsonObject)jsonObj, (String)"value", (float)0.0f);
            Operation op = jsonObj.has("op") ? Operation.byName(JSONUtils.func_151200_h((JsonObject)jsonObj, (String)"op")) : part.getDefaultStatOperation(stat);
            return new StatInstance(value, op);
        }
        throw new JsonParseException("Expected stat modifier JSON to be float or object");
    }

    @Nullable
    private static StatInstance readShorthandObject(IGearPart part, ItemStat stat, JsonObject json) {
        StatInstance result = null;
        for (Map.Entry entry : json.entrySet()) {
            Operation op = Operation.byNameOrNull((String)entry.getKey());
            if (op == null) continue;
            if (result == null) {
                result = new StatInstance(((JsonElement)entry.getValue()).getAsFloat(), op);
                continue;
            }
            throw new JsonParseException("Found multiple op keys in stat modifier object");
        }
        return result;
    }

    @Deprecated
    public static StatInstance read(String id, PacketBuffer buffer) {
        float value = buffer.readFloat();
        Operation op = (Operation)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)Operation.AVG);
        return new StatInstance(id, value, op);
    }

    public static StatInstance read(PacketBuffer buffer) {
        float value = buffer.readFloat();
        Operation op = (Operation)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)Operation.AVG);
        return new StatInstance(value, op);
    }

    public void write(PacketBuffer buffer) {
        buffer.writeFloat(this.value);
        buffer.writeByte(this.op.ordinal());
    }

    public static enum Operation {
        AVG,
        ADD,
        MUL1,
        MUL2,
        MAX;


        public static Operation byName(String str) {
            for (Operation op : Operation.values()) {
                if (!op.name().equalsIgnoreCase(str)) continue;
                return op;
            }
            return AVG;
        }

        @Nullable
        public static Operation byNameOrNull(String str) {
            for (Operation op : Operation.values()) {
                if (!op.name().equalsIgnoreCase(str)) continue;
                return op;
            }
            return null;
        }
    }
}

