/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartConst;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.type.BindingPart;
import net.silentchaos512.gear.parts.type.BowstringPart;
import net.silentchaos512.gear.parts.type.GripPart;
import net.silentchaos512.gear.parts.type.HighlightPart;
import net.silentchaos512.gear.parts.type.MainPart;
import net.silentchaos512.gear.parts.type.RodPart;
import net.silentchaos512.gear.parts.type.TipPart;
import net.silentchaos512.gear.parts.type.UpgradePart;

public final class PartType {
    private static final Map<ResourceLocation, PartType> VALUES = new HashMap<ResourceLocation, PartType>();
    public static final PartType BINDING = PartType.create(SilentGear.getId("binding"), PartType.createSerializer("binding", BindingPart::new));
    public static final PartType BOWSTRING = PartType.create(SilentGear.getId("bowstring"), PartType.createSerializer("bowstring", BowstringPart::new), PartConst.FALLBACK_BOWSTRING);
    public static final PartType GRIP = PartType.create(SilentGear.getId("grip"), PartType.createSerializer("grip", GripPart::new));
    public static final PartType HIGHLIGHT = PartType.create(SilentGear.getId("highlight"), PartType.createSerializer("highlight", HighlightPart::new));
    public static final PartType MAIN = PartType.create(SilentGear.getId("main"), PartType.createSerializer("main", MainPart::new), PartConst.FALLBACK_MAIN);
    public static final PartType MISC_UPGRADE = PartType.create(SilentGear.getId("misc_upgrade"), PartType.createSerializer("misc_upgrade", UpgradePart::new));
    public static final PartType ROD = PartType.create(SilentGear.getId("rod"), PartType.createSerializer("rod", RodPart::new), PartConst.FALLBACK_ROD);
    public static final PartType TIP = PartType.create(SilentGear.getId("tip"), PartType.createSerializer("tip", TipPart::new));
    private final ResourceLocation name;
    private final int maxPerItem;
    private final IPartSerializer<? extends IGearPart> serializer;
    @Nullable
    private final ResourceLocation fallbackPart;

    @Deprecated
    public static PartType create(ResourceLocation name, String debugSymbol, IPartSerializer<? extends IGearPart> serializer) {
        return PartType.create(name, serializer);
    }

    public static PartType create(ResourceLocation name, IPartSerializer<? extends IGearPart> serializer) {
        return PartType.create(name, serializer, null);
    }

    public static PartType create(ResourceLocation name, IPartSerializer<? extends IGearPart> serializer, @Nullable ResourceLocation fallbackPart) {
        if (VALUES.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Already have PartType \"%s\"", name));
        }
        int maxPerItem = name.equals((Object)SilentGear.getId("main")) ? 9 : 1;
        PartType type = new PartType(name, maxPerItem, serializer, fallbackPart);
        VALUES.put(name, type);
        return type;
    }

    @Deprecated
    @Nullable
    public static PartType get(String name) {
        return PartType.get(new ResourceLocation(name));
    }

    @Nullable
    public static PartType get(ResourceLocation name) {
        return VALUES.get(name);
    }

    public static Collection<PartType> getValues() {
        return VALUES.values();
    }

    private PartType(ResourceLocation name, int maxPerItem, IPartSerializer<? extends IGearPart> serializer, @Nullable ResourceLocation fallbackPart) {
        this.name = name;
        this.maxPerItem = maxPerItem;
        this.serializer = serializer;
        this.fallbackPart = fallbackPart;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getMaxPerItem() {
        return this.maxPerItem;
    }

    public ITextComponent getDisplayName(int tier) {
        return new TranslationTextComponent("part." + this.name.func_110624_b() + ".type." + this.name.func_110623_a(), new Object[]{tier});
    }

    public IPartSerializer<? extends IGearPart> getSerializer() {
        return this.serializer;
    }

    @Nullable
    public IGearPart getFallbackPart() {
        if (this.fallbackPart == null) {
            return null;
        }
        return PartManager.get(this.fallbackPart);
    }

    public String toString() {
        return "PartType{name='" + this.name + "'}";
    }

    private static <T extends AbstractGearPart> IPartSerializer<T> createSerializer(String id, Function<ResourceLocation, T> function) {
        return new AbstractGearPart.Serializer<T>(new ResourceLocation("silentgear", id), function);
    }
}

