/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.api.parts.IPartMaterial;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.RepairContext;

public interface IGearPart {
    public ResourceLocation getId();

    public int getTier();

    public PartType getType();

    public IPartPosition getPartPosition();

    public IPartMaterial getMaterials();

    public IPartSerializer<?> getSerializer();

    public void retainData(@Nullable IGearPart var1);

    default public Collection<StatInstance> getStatModifiers(ItemStat stat, PartData part) {
        return this.getStatModifiers(ItemStack.field_190927_a, stat, part);
    }

    public Collection<StatInstance> getStatModifiers(ItemStack var1, ItemStat var2, PartData var3);

    default public List<PartTraitInstance> getTraits(PartData part) {
        return this.getTraits(ItemStack.field_190927_a, part);
    }

    public List<PartTraitInstance> getTraits(ItemStack var1, PartData var2);

    public StatInstance.Operation getDefaultStatOperation(ItemStat var1);

    public float getRepairAmount(RepairContext var1);

    default public float computeStatValue(ItemStat stat) {
        return this.computeStatValue(stat, PartData.of(this));
    }

    default public float computeStatValue(ItemStat stat, PartData part) {
        return stat.compute(0.0f, this.getStatModifiers(stat, part));
    }

    default public float computeUnclampedStatValue(ItemStat stat) {
        return stat.compute(0.0f, false, this.getStatModifiers(stat, PartData.of(this)));
    }

    default public double getSalvageLossRate(ItemStack gear, PartData part, double normalLossRate) {
        return normalLossRate;
    }

    default public boolean isCraftingAllowed(@Nullable GearType gearType) {
        if (gearType != null && this.getType() == PartType.MAIN) {
            if (gearType.matches("armor")) {
                return this.computeUnclampedStatValue(ItemStats.ARMOR_DURABILITY) > 0.0f;
            }
            return this.computeUnclampedStatValue(ItemStats.DURABILITY) > 0.0f;
        }
        return true;
    }

    default public void onGearDamaged(PartData part, ItemStack gear, int amount) {
    }

    public IPartDisplay getDisplayProperties(PartData var1, ItemStack var2, int var3);

    @Deprecated
    @Nullable
    public ResourceLocation getTexture(PartData var1, ItemStack var2, GearType var3, IPartPosition var4, int var5);

    @Deprecated
    @Nullable
    public ResourceLocation getBrokenTexture(PartData var1, ItemStack var2, GearType var3, IPartPosition var4);

    public int getColor(PartData var1, ItemStack var2, int var3);

    public ITextComponent getDisplayName(@Nullable PartData var1, ItemStack var2);

    @Nullable
    default public ITextComponent getDisplayNamePrefix(@Nullable PartData part, ItemStack gear) {
        return null;
    }

    @Deprecated
    public String getModelIndex(PartData var1, int var2);

    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(PartData var1, ItemStack var2, List<ITextComponent> var3, ITooltipFlag var4);

    default public boolean isVisible() {
        return true;
    }

    default public PartData randomizeData() {
        return PartData.of(this);
    }

    default public void onRemoveFromGear(ItemStack gear, PartData part) {
    }
}

