/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.cargoinstance.capability;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xyz.brassgoggledcoders.transport.api.cargo.Cargo;
import xyz.brassgoggledcoders.transport.api.cargocarrier.ICargoCarrier;
import xyz.brassgoggledcoders.transport.capability.FluidTankPlusComponent;
import xyz.brassgoggledcoders.transport.cargoinstance.capability.CapabilityCargoInstance;
import xyz.brassgoggledcoders.transport.container.containeraddon.IContainerAddon;

public class FluidCargoInstance
extends CapabilityCargoInstance<IFluidHandler> {
    private final FluidTankPlusComponent<?> fluidTank = new FluidTankPlusComponent("Tank", 10000, 80, 28);
    private final LazyOptional<IFluidHandler> lazyFluidTank = LazyOptional.of(() -> this.fluidTank);

    public FluidCargoInstance(Cargo cargo) {
        super(cargo, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Override
    public ActionResultType applyInteraction(ICargoCarrier carrier, PlayerEntity player, Vec3d vec, Hand hand) {
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, this.fluidTank)) {
            return ActionResultType.SUCCESS;
        }
        return super.applyInteraction(carrier, player, vec, hand);
    }

    @Override
    protected LazyOptional<IFluidHandler> getLazyOptional() {
        return this.lazyFluidTank;
    }

    @Override
    protected CompoundNBT serializeCapability() {
        return this.fluidTank.writeToNBT(new CompoundNBT());
    }

    @Override
    protected void deserializeCapability(CompoundNBT nbt) {
        this.fluidTank.readFromNBT(nbt);
    }

    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.fluidTank.getScreenAddons();
    }

    @Override
    public List<IContainerAddon> getContainerAddons() {
        return Collections.singletonList(this.fluidTank);
    }
}

