/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers;

import com.buuz135.industrial.api.IndustrialForegoingHelper;
import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.FluidDictionaryEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import com.buuz135.industrial.api.recipe.SludgeEntry;
import com.buuz135.industrial.utils.TagUtil;
import com.buuz135.industrial.utils.apihandlers.crafttweaker.CTAction;
import com.google.common.collect.LinkedListMultimap;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.Tags;

public class RecipeHandlers {
    public static final LinkedListMultimap<CTAction, BioReactorEntry> BIOREACTOR_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, LaserDrillEntry> LASER_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, SludgeEntry> SLUDGE_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, ProteinReactorEntry> PROTEIN_REACTOR_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, FluidDictionaryEntry> FLUID_DICTIONARY_ENTRIES = LinkedListMultimap.create();

    public static void loadBioReactorEntries() {
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Items.field_151014_N)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Items.field_151080_bb)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Items.field_151081_bc)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Items.field_185163_cU)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Items.field_151172_bF)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Items.field_151174_bG)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Items.field_151075_bm)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Blocks.field_150338_P)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Blocks.field_150337_Q)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Blocks.field_185766_cS)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)Blocks.field_196608_cF)));
        TagUtil.getAllEntries(Tags.Items.DYES).forEach(item -> IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((IItemProvider)item))));
        TagUtil.getAllEntries(ItemTags.field_200037_g).stream().filter(item -> !item.getRegistryName().func_110624_b().equals("forestry")).map(ItemStack::new).forEach(stack -> IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry((ItemStack)stack)));
    }

    public static void executeCraftweakerActions() {
        BIOREACTOR_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addBioReactorEntry(entry);
            } else {
                IndustrialForegoingHelper.removeBioReactorEntry(entry.getStack());
            }
        });
        LASER_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addLaserDrillEntry(entry);
            } else {
                IndustrialForegoingHelper.removeLaserDrillEntry(entry.getStack());
            }
        });
        SLUDGE_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addSludgeRefinerEntry(entry);
            } else {
                IndustrialForegoingHelper.removeSludgeRefinerEntry(entry.getStack());
            }
        });
        PROTEIN_REACTOR_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addProteinReactorEntry(entry);
            } else {
                IndustrialForegoingHelper.removeProteinReactorEntry(entry.getStack());
            }
        });
        FLUID_DICTIONARY_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addFluidDictionaryEntry(entry);
            } else {
                IndustrialForegoingHelper.removeFluidDictionaryEntry(entry);
            }
        });
    }

    public static void loadSludgeRefinerEntries() {
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((IItemProvider)Items.field_151119_aD), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((IItemProvider)Blocks.field_150435_aG), 1));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((IItemProvider)Blocks.field_150346_d), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((IItemProvider)Blocks.field_150351_n), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((IItemProvider)Blocks.field_150391_bh), 1));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((IItemProvider)Blocks.field_150354_m), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((IItemProvider)Blocks.field_150425_aM), 4));
    }

    public static void loadProteinReactorEntries() {
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_151147_al)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_151082_bd)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_151076_bf)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_179558_bo)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_179561_bm)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_179556_br)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_151078_bh)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_151110_aK)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_151070_bp)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack((IItemProvider)Items.field_151147_al)));
        NonNullList stacks = NonNullList.func_191196_a();
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196088_aY));
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196089_aZ));
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196087_aX));
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196086_aW));
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196182_dv));
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196185_dy));
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196151_dA));
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196184_dx));
        stacks.add((Object)new ItemStack((IItemProvider)Items.field_196186_dz));
        stacks.forEach(stack -> IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry((ItemStack)stack)));
    }

    public static void loadFluidDictionaryEntries() {
        RecipeHandlers.addFluidEntryDoubleDirectional("essence", "xpjuice", 1.0);
        RecipeHandlers.addFluidEntryDoubleDirectional("essence", "experience", 1.0);
        RecipeHandlers.addFluidEntryDoubleDirectional("xpjuice", "experience", 1.0);
    }

    public static void loadWoodToLatexEntries() {
    }

    public static void loadOreEntries() {
    }

    public static void addFluidEntryDoubleDirectional(String fluidInput, String fluidOutput, double ratio) {
        IndustrialForegoingHelper.addFluidDictionaryEntry(new FluidDictionaryEntry(fluidInput, fluidOutput, ratio));
        IndustrialForegoingHelper.addFluidDictionaryEntry(new FluidDictionaryEntry(fluidOutput, fluidInput, 1.0 / ratio));
    }

    public static void getSubItems(NonNullList<ItemStack> list, ItemStack stack) {
        if (stack.func_77973_b().func_77640_w() != null) {
            stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), list);
        }
    }
}

