/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.jei.category;

import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class FluidExtractorCategory
implements IRecipeCategory<FluidExtractorRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("industrialforegoing", "fluid_extractor");
    private IGuiHelper guiHelper;
    private IDrawable tankOverlay;

    public FluidExtractorCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.tankOverlay = guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 1, 207, 12, 48);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends FluidExtractorRecipe> getRecipeClass() {
        return FluidExtractorRecipe.class;
    }

    public String getTitle() {
        return "Fluid Extractor";
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 27, 76, 50).addPadding(0, 0, 0, 74).build();
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(FluidExtractorRecipe fluidExtractorRecipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, new ArrayList(fluidExtractorRecipe.input.func_199799_a()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)fluidExtractorRecipe.output);
        if (!new ItemStack((IItemProvider)fluidExtractorRecipe.result).func_190926_b()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)fluidExtractorRecipe.result));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidExtractorRecipe fluidExtractorRecipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(0, true, 0, 16);
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() > 0) {
            guiItemStackGroup.init(1, false, 27, 34);
            guiItemStackGroup.setBackground(1, (IDrawable)this.guiHelper.getSlotDrawable());
            guiItemStackGroup.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
        IGuiFluidStackGroup guiFluidStackGroup = recipeLayout.getFluidStacks();
        guiFluidStackGroup.init(1, false, 57, 1, 12, 48, Math.max(50, ((FluidStack)((List)ingredients.getOutputs(VanillaTypes.FLUID).get(0)).get(0)).getAmount()), false, this.tankOverlay);
        guiItemStackGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        guiFluidStackGroup.set(1, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
    }

    public void draw(FluidExtractorRecipe recipe, double mouseX, double mouseY) {
        Minecraft.func_71410_x().field_71466_p.func_211126_b(TextFormatting.DARK_GRAY + "Production: ", 80.0f, 6.0f, 0xFFFFFF);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String string = TextFormatting.DARK_GRAY + "" + recipe.output.getAmount() + "mb/12ticks";
        Minecraft.func_71410_x().field_71466_p.getClass();
        fontRenderer.func_211126_b(string, 80.0f, (float)(6 + (9 + 2) * 1), 0xFFFFFF);
        FontRenderer fontRenderer2 = Minecraft.func_71410_x().field_71466_p;
        String string2 = TextFormatting.DARK_GRAY + "Average: ";
        Minecraft.func_71410_x().field_71466_p.getClass();
        fontRenderer2.func_211126_b(string2, 80.0f, (float)(6 + (9 + 2) * 2), 0xFFFFFF);
        FontRenderer fontRenderer3 = Minecraft.func_71410_x().field_71466_p;
        String string3 = TextFormatting.DARK_GRAY + "" + (int)(8.0f / recipe.breakChance) * recipe.output.getAmount() + "mb";
        Minecraft.func_71410_x().field_71466_p.getClass();
        fontRenderer3.func_211126_b(string3, 80.0f, (float)(6 + (9 + 2) * 3), 0xFFFFFF);
    }

    public List<String> getTooltipStrings(FluidExtractorRecipe recipe, double mouseX, double mouseY) {
        if (mouseX >= 78.0 && mouseX <= 140.0 && mouseY >= 5.0 && mouseY <= 25.0) {
            return Arrays.asList("Production rate");
        }
        if (mouseX >= 78.0 && mouseX <= 120.0 && mouseY >= 25.0 && mouseY <= 45.0) {
            return Arrays.asList("Average numbers aren't real numbers");
        }
        return new ArrayList<String>();
    }
}

