/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.net;

import java.util.function.Supplier;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCraftStack {
    private final int slotNumber;

    public MessageCraftStack(int slotId) {
        this.slotNumber = slotId;
    }

    public static MessageCraftStack decode(PacketBuffer buf) {
        byte slotNumber = buf.readByte();
        return new MessageCraftStack(slotNumber);
    }

    public static void encode(MessageCraftStack message, PacketBuffer buf) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(MessageCraftStack message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            Container container = player.field_71070_bA;
            if (container == null || message.slotNumber < 0 || message.slotNumber >= container.field_75151_b.size()) {
                return;
            }
            TweakProvider<Container> tweakProvider = CraftingTweaksProviderManager.getProvider(container);
            if (tweakProvider == null) {
                return;
            }
            Slot mouseSlot = (Slot)container.field_75151_b.get(message.slotNumber);
            ItemStack mouseStack = player.field_71071_by.func_70445_o();
            for (int maxTries = 64; maxTries > 0 && mouseSlot.func_75216_d() && (mouseStack.func_190926_b() || mouseStack.func_190916_E() + mouseSlot.func_75211_c().func_190916_E() <= mouseStack.func_77976_d()); --maxTries) {
                container.func_184996_a(mouseSlot.field_75222_d, 0, ClickType.PICKUP, (PlayerEntity)player);
                mouseStack = player.field_71071_by.func_70445_o();
            }
            player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, player.field_71071_by.func_70445_o()));
        });
    }
}

