/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;

public final class Dimensions
extends Enum<Dimensions> {
    public static final /* enum */ Dimensions THE_NETHER = new Dimensions(DimensionType.field_223228_b_, "netherrack");
    public static final /* enum */ Dimensions OVERWORLD = new Dimensions(DimensionType.field_223227_a_, "#forge:stone");
    public static final /* enum */ Dimensions THE_END = new Dimensions(DimensionType.field_223229_c_, "end_stone");
    public final DimensionType type;
    public final UnitId replaceableBlockId;
    public static final String DIM_LIST_SYNTAX = "Dimension is specified by its ID [-1 - Nether, 0 - Overworld, 1 - The End, etc.]\nEach ID must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.";
    private static final /* synthetic */ Dimensions[] $VALUES;

    public static Dimensions[] values() {
        return (Dimensions[])$VALUES.clone();
    }

    public static Dimensions valueOf(String name) {
        return Enum.valueOf(Dimensions.class, name);
    }

    private Dimensions(DimensionType type, String replaceableBlockId) {
        this.type = type;
        this.replaceableBlockId = UnitId.from(replaceableBlockId);
        assert (replaceableBlockId != null);
    }

    public static CommonCollect.BlackWhiteList<DimensionType> from(UnitConfig config, String category, String comment) {
        category = IHaveConfig.expandClassCategory(Dimensions.class, category);
        if (config != null) {
            config.setCategoryComment(category, comment + "\n" + DIM_LIST_SYNTAX);
        }
        List<DimensionType> black = Dimensions.readFrom(config, category, "blackList", "");
        List<DimensionType> white = Dimensions.readFrom(config, category, "whiteList", "");
        return new CommonCollect.BlackWhiteList<DimensionType>(black, white);
    }

    public static List<DimensionType> readFrom(UnitConfig config, String category, String key, String comment) {
        if (config == null) {
            return Collections.emptyList();
        }
        String[] strArray = config.getStrArray(category, key, new String[0], comment);
        ArrayList<DimensionType> list = new ArrayList<DimensionType>();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            ResourceLocation regName = new ResourceLocation(str);
            Optional dimType = DimensionManager.getRegistry().func_218349_b(regName);
            if (dimType.isPresent()) {
                list.add((DimensionType)dimType.get());
                continue;
            }
            ForgeEndertech.getInstance().getLogger().warn("Dimension {} does not exist. Config {}", (Object)regName, (Object)config);
        }
        return list;
    }

    static {
        $VALUES = new Dimensions[]{THE_NETHER, OVERWORLD, THE_END};
    }
}

