/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.config.ModJetpacks;
import com.blakebr0.ironjetpacks.item.ComponentItem;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModItems {
    public static final List<Supplier<? extends Item>> ENTRIES = new ArrayList<Supplier<? extends Item>>();
    public static final RegistryObject<BaseItem> STRAP = ModItems.register("strap");
    public static final RegistryObject<BaseItem> BASIC_COIL = ModItems.register("basic_coil");
    public static final RegistryObject<BaseItem> ADVANCED_COIL = ModItems.register("advanced_coil");
    public static final RegistryObject<BaseItem> ELITE_COIL = ModItems.register("elite_coil");
    public static final RegistryObject<BaseItem> ULTIMATE_COIL = ModItems.register("ultimate_coil");

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        ComponentItem item;
        IForgeRegistry registry = event.getRegistry();
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        ENTRIES.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        ModJetpacks.loadJsons();
        for (Jetpack jetpack : jetpacks.getAllJetpacks()) {
            item = new ComponentItem(jetpack, "cell", p -> p.func_200916_a(IronJetpacks.ITEM_GROUP));
            jetpack.setCellItem(item);
            registry.register(item.setRegistryName(jetpack.name + "_cell"));
        }
        for (Jetpack jetpack : jetpacks.getAllJetpacks()) {
            item = new ComponentItem(jetpack, "thruster", p -> p.func_200916_a(IronJetpacks.ITEM_GROUP));
            jetpack.setThrusterItem(item);
            registry.register(item.setRegistryName(jetpack.name + "_thruster"));
        }
        for (Jetpack jetpack : jetpacks.getAllJetpacks()) {
            item = new ComponentItem(jetpack, "capacitor", p -> p.func_200916_a(IronJetpacks.ITEM_GROUP));
            jetpack.setCapacitorItem(item);
            registry.register(item.setRegistryName(jetpack.name + "_capacitor"));
        }
        for (Jetpack jetpack : jetpacks.getAllJetpacks()) {
            registry.register(jetpack.item.setRegistryName(jetpack.name + "_jetpack"));
        }
    }

    private static <T extends Item> RegistryObject<T> register(String name) {
        return ModItems.register(name, () -> new BaseItem(p -> p.func_200916_a(IronJetpacks.ITEM_GROUP)));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<? extends Item> item) {
        ResourceLocation loc = new ResourceLocation("ironjetpacks", name);
        ENTRIES.add(() -> (Item)((Item)item.get()).setRegistryName(loc));
        return RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.ITEMS);
    }
}

