/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.core;

import com.bagel.buzzierbees.common.dispenser.BeeBottleDispenseBehavior;
import com.bagel.buzzierbees.common.dispenser.BugBottleDispenseBehavior;
import com.bagel.buzzierbees.common.items.BBSpawnEggItem;
import com.bagel.buzzierbees.core.registry.BBBlockData;
import com.bagel.buzzierbees.core.registry.BBBlocks;
import com.bagel.buzzierbees.core.registry.BBEffects;
import com.bagel.buzzierbees.core.registry.BBEntities;
import com.bagel.buzzierbees.core.registry.BBFeatures;
import com.bagel.buzzierbees.core.registry.BBItems;
import com.bagel.buzzierbees.core.registry.BBTileEntities;
import com.bagel.buzzierbees.core.util.BlockColorManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="buzzierbees")
@Mod.EventBusSubscriber(modid="buzzierbees")
public class BuzzierBees {
    public static final String MODID = "buzzierbees";

    public BuzzierBees() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BBItems.ITEMS.register(modEventBus);
        BBEffects.EFFECTS.register(modEventBus);
        BBEffects.POTIONS.register(modEventBus);
        BBBlocks.BLOCKS.register(modEventBus);
        BBEntities.ENTITIES.register(modEventBus);
        BBTileEntities.TILE_ENTITY_TYPES.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::replaceBeehivePOI);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(EventPriority.LOWEST, this::registerItemColors);
            modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
        });
    }

    public void initSetupClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
    }

    private void setupClient(FMLClientSetupEvent event) {
        BBBlockData.setupRenderLayer();
        BBEntities.registerRendering();
        BlockColorManager.registerBlockColors();
    }

    private void setup(FMLCommonSetupEvent event) {
        BBBlockData.registerCompostables();
        BBBlockData.registerFlammables();
        BBEffects.addBrewingRecipes();
        BBFeatures.addFeatures();
        BBEntities.addEntitySpawns();
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BBItems.BOTTLE_OF_BEE.get()), (IDispenseItemBehavior)new BeeBottleDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BBItems.BOTTLE_OF_SILVERFISH.get()), (IDispenseItemBehavior)new BugBottleDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BBItems.BOTTLE_OF_ENDERMITE.get()), (IDispenseItemBehavior)new BugBottleDispenseBehavior());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item event) {
        for (RegistryObject<Item> items : BBItems.SPAWN_EGGS) {
            Item item;
            if (ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, items, (String)"value") == null || !((item = (Item)items.get()) instanceof BBSpawnEggItem)) continue;
            event.getItemColors().func_199877_a((itemColor, itemsIn) -> ((BBSpawnEggItem)item).func_195983_a(itemsIn), new IItemProvider[]{item});
        }
    }

    private void replaceBeehivePOI(FMLCommonSetupEvent event) {
        Set NESTS;
        ImmutableList BEEHIVES = ImmutableList.of((Object)Blocks.field_226906_mb_, (Object)BBBlocks.ACACIA_BEEHIVE.get(), (Object)BBBlocks.BIRCH_BEEHIVE.get(), (Object)BBBlocks.SPRUCE_BEEHIVE.get(), (Object)BBBlocks.DARK_OAK_BEEHIVE.get(), (Object)BBBlocks.JUNGLE_BEEHIVE.get(), (Object)BBBlocks.CRIMSON_BEEHIVE.get(), (Object)BBBlocks.WARPED_BEEHIVE.get(), (Object)BBBlocks.ROSEWOOD_BEEHIVE.get(), (Object)BBBlocks.YUCCA_BEEHIVE.get(), (Object)BBBlocks.KOUSA_BEEHIVE.get(), (Object)BBBlocks.ASPEN_BEEHIVE.get(), (Object[])new Block[]{(Block)BBBlocks.WILLOW_BEEHIVE.get(), (Block)BBBlocks.WISTERIA_BEEHIVE.get(), (Block)BBBlocks.MAPLE_BEEHIVE.get(), (Block)BBBlocks.BAMBOO_BEEHIVE.get(), (Block)BBBlocks.POISE_BEEHIVE.get(), (Block)BBBlocks.DRIFTWOOD_BEEHIVE.get(), (Block)BBBlocks.RIVER_BEEHIVE.get(), (Block)BBBlocks.SNAKE_BLOCK_BEEHIVE.get(), (Block)BBBlocks.BOP_FIR_BEEHIVE.get(), (Block)BBBlocks.BOP_DEAD_BEEHIVE.get(), (Block)BBBlocks.BOP_PALM_BEEHIVE.get(), (Block)BBBlocks.BOP_MAGIC_BEEHIVE.get(), (Block)BBBlocks.BOP_CHERRY_BEEHIVE.get(), (Block)BBBlocks.BOP_UMBRAN_BEEHIVE.get(), (Block)BBBlocks.BOP_WILLOW_BEEHIVE.get(), (Block)BBBlocks.BOP_REDWOOD_BEEHIVE.get(), (Block)BBBlocks.BOP_HELLBARK_BEEHIVE.get(), (Block)BBBlocks.BOP_MAHOGANY_BEEHIVE.get(), (Block)BBBlocks.BOP_JACARANDA_BEEHIVE.get()});
        HashSet newSet = new HashSet(TileEntityType.field_226985_G_.field_223046_I);
        newSet.addAll(BEEHIVES);
        TileEntityType.field_226985_G_.field_223046_I = newSet;
        PointOfInterestType.field_226356_s_.field_221075_w = NESTS = (Set)BlockTags.field_226151_aa_.func_199885_a().stream().flatMap(map -> map.func_176194_O().func_177619_a().stream()).collect(ImmutableSet.toImmutableSet());
        HashMap<BlockState, PointOfInterestType> map2 = new HashMap<BlockState, PointOfInterestType>();
        BuzzierBees.addToMap(Blocks.field_226906_mb_, map2);
        BuzzierBees.addToMap((Block)BBBlocks.ACACIA_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BIRCH_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.SPRUCE_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.DARK_OAK_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.JUNGLE_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.CRIMSON_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.WARPED_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.ROSEWOOD_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.YUCCA_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.KOUSA_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.ASPEN_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.WILLOW_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.WISTERIA_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.MAPLE_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BAMBOO_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.POISE_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.DRIFTWOOD_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.RIVER_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.SNAKE_BLOCK_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_FIR_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_DEAD_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_PALM_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_MAGIC_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_CHERRY_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_UMBRAN_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_WILLOW_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_REDWOOD_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_HELLBARK_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_MAHOGANY_BEEHIVE.get(), map2);
        BuzzierBees.addToMap((Block)BBBlocks.BOP_JACARANDA_BEEHIVE.get(), map2);
        PointOfInterestType.field_221073_u.putAll(map2);
    }

    public static void addToMap(Block block, Map<BlockState, PointOfInterestType> pointOfInterestTypeMap) {
        block.func_176194_O().func_177619_a().forEach(state -> pointOfInterestTypeMap.put((BlockState)state, PointOfInterestType.field_226356_s_));
    }
}

