/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.utils;

import com.davenonymous.libnonymous.utils.RaytraceHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RotationTools {
    @OnlyIn(value=Dist.CLIENT)
    private static ResourceLocation arrowImage;

    @OnlyIn(value=Dist.CLIENT)
    public static void renderArrowOnGround(Vec3d hitPosition, BlockPos drawPosition, float partialTicks, MatrixStack matrix) {
        Direction facing = RotationTools.getFacingByTriangle(hitPosition);
        TextureRotationList rotList = new TextureRotationList();
        switch (facing) {
            case SOUTH: {
                break;
            }
            case WEST: {
                rotList.rotateFromStart();
                break;
            }
            case NORTH: {
                rotList.rotateFromStart();
                rotList.rotateFromStart();
                break;
            }
            case EAST: {
                rotList.rotateFromStart();
                rotList.rotateFromStart();
                rotList.rotateFromStart();
            }
        }
        if (arrowImage == null) {
            arrowImage = new ResourceLocation("libnonymous", "textures/particles/blockmarker.png");
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(arrowImage);
        matrix.func_227860_a_();
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        matrix.func_227861_a_(-renderInfo.func_216785_c().func_82615_a(), -renderInfo.func_216785_c().func_82617_b(), -renderInfo.func_216785_c().func_82616_c());
        matrix.func_227861_a_((double)drawPosition.func_177958_n(), (double)drawPosition.func_177956_o(), (double)drawPosition.func_177952_p());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        rotList.fillBufferBuilder(bufferbuilder, 5.0E-4);
        tessellator.func_78381_a();
        matrix.func_227865_b_();
    }

    public static Direction getFacingForPlayer(World world, PlayerEntity player) {
        float blockReachDistance = 6.0f;
        BlockRayTraceResult trace = RaytraceHelper.rayTrace(world, (Entity)player, blockReachDistance);
        if (trace == null) {
            return null;
        }
        Vec3d hitPosition = trace.func_216347_e();
        hitPosition = hitPosition.func_178788_d(new Vec3d((Vec3i)trace.func_216350_a()));
        hitPosition = hitPosition.func_178786_a(0.5, 0.5, 0.5);
        return RotationTools.getFacingByTriangle(hitPosition);
    }

    public static Direction getFacingByTriangle(Vec3d vec) {
        if (vec.field_72449_c > 0.0) {
            if (vec.field_72450_a < 0.0) {
                if (Math.abs(vec.field_72450_a) < Math.abs(vec.field_72449_c)) {
                    return Direction.SOUTH;
                }
                return Direction.WEST;
            }
            if (Math.abs(vec.field_72450_a) > Math.abs(vec.field_72449_c)) {
                return Direction.EAST;
            }
            return Direction.SOUTH;
        }
        if (vec.field_72450_a < 0.0) {
            if (Math.abs(vec.field_72450_a) < Math.abs(vec.field_72449_c)) {
                return Direction.NORTH;
            }
            return Direction.WEST;
        }
        if (Math.abs(vec.field_72450_a) > Math.abs(vec.field_72449_c)) {
            return Direction.EAST;
        }
        return Direction.NORTH;
    }

    public static class RotatingList<T>
    extends ArrayList<T> {
        public void rotateFromStart() {
            Object firstElement = this.get(0);
            this.remove(0);
            this.add(firstElement);
        }

        public void rotateFromEnd() {
            Object lastElement = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            this.add(0, lastElement);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TextureRotationList
    extends RotatingList<Tuple<Integer, Integer>> {
        public TextureRotationList() {
            this.add(new Tuple((Object)0, (Object)1));
            this.add(new Tuple((Object)1, (Object)1));
            this.add(new Tuple((Object)1, (Object)0));
            this.add(new Tuple((Object)0, (Object)0));
        }

        public void fillBufferBuilder(BufferBuilder buffer, double yLevel) {
            buffer.func_225582_a_(0.0, yLevel, 1.0).func_225583_a_((float)((Integer)((Tuple)this.get(0)).func_76341_a()).intValue(), (float)((Integer)((Tuple)this.get(0)).func_76340_b()).intValue()).func_181675_d();
            buffer.func_225582_a_(1.0, yLevel, 1.0).func_225583_a_((float)((Integer)((Tuple)this.get(1)).func_76341_a()).intValue(), (float)((Integer)((Tuple)this.get(1)).func_76340_b()).intValue()).func_181675_d();
            buffer.func_225582_a_(1.0, yLevel, 0.0).func_225583_a_((float)((Integer)((Tuple)this.get(2)).func_76341_a()).intValue(), (float)((Integer)((Tuple)this.get(2)).func_76340_b()).intValue()).func_181675_d();
            buffer.func_225582_a_(0.0, yLevel, 0.0).func_225583_a_((float)((Integer)((Tuple)this.get(3)).func_76341_a()).intValue(), (float)((Integer)((Tuple)this.get(3)).func_76340_b()).intValue()).func_181675_d();
        }
    }
}

