/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization.nbt;

import com.davenonymous.libnonymous.serialization.FieldUtils;
import com.davenonymous.libnonymous.serialization.Store;
import com.davenonymous.libnonymous.serialization.nbt.NBTFieldHandlers;
import com.davenonymous.libnonymous.serialization.nbt.NBTFieldSerializationData;
import com.davenonymous.libnonymous.utils.Logz;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;

public class NBTFieldUtils {
    private static Map<Class, List<NBTFieldSerializationData>> classNbtCache = new HashMap<Class, List<NBTFieldSerializationData>>();

    public static CompoundNBT writeFieldsToNBT(List<NBTFieldSerializationData> NBTActions, Object source, CompoundNBT targetCompound, Predicate<NBTFieldSerializationData> test) {
        for (NBTFieldSerializationData data : NBTActions) {
            if (!test.test(data)) continue;
            try {
                Object value = data.field.get(source);
                data.writer.write(data.key, value, targetCompound);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return targetCompound;
    }

    public static void readFieldsFromNBT(List<NBTFieldSerializationData> NBTActions, Object target, CompoundNBT sourceCompound, Predicate<NBTFieldSerializationData> test) {
        for (NBTFieldSerializationData data : NBTActions) {
            if (!test.test(data)) continue;
            try {
                Object value = data.reader.read(data.key, sourceCompound);
                data.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<NBTFieldSerializationData> initSerializableStoreFields(Class clz) {
        if (classNbtCache.containsKey(clz)) {
            return classNbtCache.get(clz);
        }
        ArrayList<NBTFieldSerializationData> actionList = new ArrayList<NBTFieldSerializationData>();
        for (Field field : FieldUtils.getAllDeclaredFields(clz)) {
            Store annotation = field.getDeclaredAnnotation(Store.class);
            if (annotation == null || !(annotation instanceof Store)) continue;
            if (!NBTFieldHandlers.hasNBTHandler(field.getType())) {
                Logz.warn("No NBT serialization methods for field='{}' (type='{}') in class='{}' exists.", field.getName(), field.getType().getSimpleName(), clz.getSimpleName());
                continue;
            }
            Store storeAnnotation = annotation;
            String key = storeAnnotation.key();
            if (key.equals("")) {
                key = field.getName();
            }
            actionList.add(new NBTFieldSerializationData(field, key, storeAnnotation.storeWithItem(), storeAnnotation.sendInUpdatePackage()));
            field.setAccessible(true);
        }
        classNbtCache.put(clz, actionList);
        return actionList;
    }
}

