/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid.view;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.screen.grid.GridScreen;
import com.raoulvdberge.refinedstorage.screen.grid.filtering.GridFilterParser;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.SortingDirection;
import com.raoulvdberge.refinedstorage.screen.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.view.IGridView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public abstract class BaseGridView
implements IGridView {
    private GridScreen screen;
    private boolean canCraft;
    private IGridSorter defaultSorter;
    private List<IGridSorter> sorters;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();
    protected Map<UUID, IGridStack> map = new HashMap<UUID, IGridStack>();

    public BaseGridView(GridScreen screen, IGridSorter defaultSorter, List<IGridSorter> sorters) {
        this.screen = screen;
        this.defaultSorter = defaultSorter;
        this.sorters = sorters;
    }

    @Override
    public List<IGridStack> getStacks() {
        return this.stacks;
    }

    @Override
    @Nullable
    public IGridStack get(UUID id) {
        return this.map.get(id);
    }

    @Override
    public void sort() {
        if (!this.screen.canSort()) {
            return;
        }
        ArrayList<IGridStack> stacks = new ArrayList<IGridStack>();
        if (this.screen.getGrid().isGridActive()) {
            stacks.addAll(this.map.values());
            IGrid grid = this.screen.getGrid();
            List<Predicate<IGridStack>> filters = GridFilterParser.getFilters(grid, this.screen.getSearchFieldText(), grid.getTabSelected() >= 0 && grid.getTabSelected() < grid.getTabs().size() ? grid.getTabs().get(grid.getTabSelected()).getFilters() : grid.getFilters());
            Iterator it = stacks.iterator();
            block0: while (it.hasNext()) {
                IGridStack stack = (IGridStack)it.next();
                if (this.screen.getGrid().getViewType() != 2 && stack.isCraftable() && stack.getOtherId() != null && this.map.containsKey(stack.getOtherId())) {
                    it.remove();
                    continue;
                }
                for (Predicate predicate : filters) {
                    if (predicate.test(stack)) continue;
                    it.remove();
                    continue block0;
                }
            }
            SortingDirection sortingDirection = grid.getSortingDirection() == 1 ? SortingDirection.DESCENDING : SortingDirection.ASCENDING;
            stacks.sort((left, right) -> this.defaultSorter.compare((IGridStack)left, (IGridStack)right, sortingDirection));
            for (IGridSorter iGridSorter : this.sorters) {
                if (!iGridSorter.isApplicable(grid)) continue;
                stacks.sort((left, right) -> sorter.compare((IGridStack)left, (IGridStack)right, sortingDirection));
            }
        }
        this.stacks = stacks;
        this.screen.updateScrollbar();
    }

    @Override
    public void setCanCraft(boolean canCraft) {
        this.canCraft = canCraft;
    }

    @Override
    public boolean canCraft() {
        return this.canCraft;
    }
}

