/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network.grid;

import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.raoulvdberge.refinedstorage.container.GridContainer;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class GridProcessingTransferMessage {
    private Collection<ItemStack> inputs;
    private Collection<ItemStack> outputs;
    private Collection<FluidStack> fluidInputs;
    private Collection<FluidStack> fluidOutputs;

    public GridProcessingTransferMessage(Collection<ItemStack> inputs, Collection<ItemStack> outputs, Collection<FluidStack> fluidInputs, Collection<FluidStack> fluidOutputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.fluidInputs = fluidInputs;
        this.fluidOutputs = fluidOutputs;
    }

    public static GridProcessingTransferMessage decode(PacketBuffer buf) {
        int size = buf.readInt();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            inputs.add(StackUtils.readItemStack(buf));
        }
        size = buf.readInt();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            outputs.add(StackUtils.readItemStack(buf));
        }
        size = buf.readInt();
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            fluidInputs.add(FluidStack.readFromPacket((PacketBuffer)buf));
        }
        size = buf.readInt();
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            fluidOutputs.add(FluidStack.readFromPacket((PacketBuffer)buf));
        }
        return new GridProcessingTransferMessage(inputs, outputs, fluidInputs, fluidOutputs);
    }

    public static void encode(GridProcessingTransferMessage message, PacketBuffer buf) {
        buf.writeInt(message.inputs.size());
        for (ItemStack itemStack : message.inputs) {
            StackUtils.writeItemStack(buf, itemStack);
        }
        buf.writeInt(message.outputs.size());
        for (ItemStack itemStack : message.outputs) {
            StackUtils.writeItemStack(buf, itemStack);
        }
        buf.writeInt(message.fluidInputs.size());
        for (FluidStack fluidStack : message.fluidInputs) {
            fluidStack.writeToPacket(buf);
        }
        buf.writeInt(message.fluidOutputs.size());
        for (FluidStack fluidStack : message.fluidOutputs) {
            fluidStack.writeToPacket(buf);
        }
    }

    public static void handle(GridProcessingTransferMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> GridProcessingTransferMessage.lambda$handle$0((PlayerEntity)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static void clearInputsAndOutputs(BaseItemHandler handler) {
        for (int i = 0; i < 18; ++i) {
            handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    private static void clearInputsAndOutputs(FluidInventory handler) {
        for (int i = 0; i < 18; ++i) {
            handler.setFluid(i, FluidStack.EMPTY);
        }
    }

    private static void setInputs(BaseItemHandler handler, Collection<ItemStack> stacks) {
        GridProcessingTransferMessage.setSlots(handler, stacks, 0, 9);
    }

    private static void setOutputs(BaseItemHandler handler, Collection<ItemStack> stacks) {
        GridProcessingTransferMessage.setSlots(handler, stacks, 9, 18);
    }

    private static void setSlots(BaseItemHandler handler, Collection<ItemStack> stacks, int begin, int end) {
        for (ItemStack stack : stacks) {
            handler.setStackInSlot(begin, stack);
            if (++begin < end) continue;
            break;
        }
    }

    private static void setFluidInputs(FluidInventory inventory, Collection<FluidStack> stacks) {
        GridProcessingTransferMessage.setFluidSlots(inventory, stacks, 0, 9);
    }

    private static void setFluidOutputs(FluidInventory inventory, Collection<FluidStack> stacks) {
        GridProcessingTransferMessage.setFluidSlots(inventory, stacks, 9, 18);
    }

    private static void setFluidSlots(FluidInventory inventory, Collection<FluidStack> stacks, int begin, int end) {
        for (FluidStack stack : stacks) {
            inventory.setFluid(begin, stack.copy());
            if (++begin < end) continue;
            break;
        }
    }

    private static /* synthetic */ void lambda$handle$0(PlayerEntity player, GridProcessingTransferMessage message) {
        IGrid grid;
        if (player.field_71070_bA instanceof GridContainer && (grid = ((GridContainer)player.field_71070_bA).getGrid()).getGridType() == GridType.PATTERN) {
            BaseItemHandler handler = ((GridNetworkNode)grid).getProcessingMatrix();
            FluidInventory handlerFluid = ((GridNetworkNode)grid).getProcessingMatrixFluids();
            GridProcessingTransferMessage.clearInputsAndOutputs(handler);
            GridProcessingTransferMessage.clearInputsAndOutputs(handlerFluid);
            GridProcessingTransferMessage.setInputs(handler, message.inputs);
            GridProcessingTransferMessage.setOutputs(handler, message.outputs);
            GridProcessingTransferMessage.setFluidInputs(handlerFluid, message.fluidInputs);
            GridProcessingTransferMessage.setFluidOutputs(handlerFluid, message.fluidOutputs);
            ((GridNetworkNode)grid).setProcessingPattern(true);
            ((GridNetworkNode)grid).markDirty();
        }
    }
}

