/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network.craftingmonitor;

import com.raoulvdberge.refinedstorage.container.CraftingMonitorContainer;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CraftingMonitorCancelMessage {
    @Nullable
    private UUID taskId;

    public CraftingMonitorCancelMessage(@Nullable UUID taskId) {
        this.taskId = taskId;
    }

    public static CraftingMonitorCancelMessage decode(PacketBuffer buf) {
        return new CraftingMonitorCancelMessage(buf.readBoolean() ? buf.func_179253_g() : null);
    }

    public static void encode(CraftingMonitorCancelMessage message, PacketBuffer buf) {
        buf.writeBoolean(message.taskId != null);
        if (message.taskId != null) {
            buf.func_179252_a(message.taskId);
        }
    }

    public static void handle(CraftingMonitorCancelMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                if (player.field_71070_bA instanceof CraftingMonitorContainer) {
                    ((CraftingMonitorContainer)player.field_71070_bA).getCraftingMonitor().onCancelled(player, message.taskId);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

