/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridFactory;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridManager;
import com.raoulvdberge.refinedstorage.container.factory.GridContainerProvider;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class GridManager
implements IGridManager {
    private final Map<ResourceLocation, IGridFactory> factories = new HashMap<ResourceLocation, IGridFactory>();

    @Override
    public void add(ResourceLocation id, IGridFactory factory) {
        this.factories.put(id, factory);
    }

    @Override
    @Nullable
    public IGridFactory get(ResourceLocation id) {
        return this.factories.get(id);
    }

    @Override
    public void openGrid(ResourceLocation id, ServerPlayerEntity player, BlockPos pos) {
        this.openGrid(id, player, null, pos, -1);
    }

    @Override
    public void openGrid(ResourceLocation id, ServerPlayerEntity player, ItemStack stack, int slotId) {
        this.openGrid(id, player, stack, null, slotId);
    }

    private void openGrid(ResourceLocation id, ServerPlayerEntity player, @Nullable ItemStack stack, @Nullable BlockPos pos, int slotId) {
        Pair<IGrid, TileEntity> grid = this.createGrid(id, (PlayerEntity)player, stack, pos, slotId);
        if (grid == null) {
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new GridContainerProvider((IGrid)grid.getLeft(), (TileEntity)grid.getRight()), buf -> {
            buf.func_192572_a(id);
            buf.writeBoolean(pos != null);
            if (pos != null) {
                buf.func_179255_a(pos);
            }
            buf.writeBoolean(stack != null);
            if (stack != null) {
                buf.func_150788_a(stack);
            }
            buf.writeInt(slotId);
        });
    }

    @Override
    @Nullable
    public Pair<IGrid, TileEntity> createGrid(ResourceLocation id, PlayerEntity player, @Nullable ItemStack stack, @Nullable BlockPos pos, int slotId) {
        IGridFactory factory = this.get(id);
        if (factory == null) {
            return null;
        }
        IGrid grid = null;
        TileEntity tile = factory.getRelevantTile(player.field_70170_p, pos);
        switch (factory.getType()) {
            case STACK: {
                grid = factory.createFromStack(player, stack, slotId);
                break;
            }
            case BLOCK: {
                grid = factory.createFromBlock(player, pos);
            }
        }
        if (grid == null) {
            return null;
        }
        return Pair.of((Object)grid, (Object)tile);
    }
}

