/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot;

import java.util.Random;
import net.minecraft.util.text.TextFormatting;

public enum LootRarity {
    COMMON(TextFormatting.GRAY),
    UNCOMMON(TextFormatting.YELLOW),
    RARE(TextFormatting.BLUE),
    EPIC(TextFormatting.DARK_PURPLE),
    ANCIENT(TextFormatting.DARK_GREEN),
    UNIQUE(TextFormatting.GOLD);

    final TextFormatting color;

    private LootRarity(TextFormatting color) {
        this.color = color;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public static LootRarity random(Random rand, int min) {
        int range = min + rand.nextInt(1000 - min);
        if (range < 400) {
            return COMMON;
        }
        if (range < 700) {
            return UNCOMMON;
        }
        if (range < 880) {
            return RARE;
        }
        if (range < 950) {
            return EPIC;
        }
        if (range < 1000) {
            return ANCIENT;
        }
        return UNIQUE;
    }

    public static LootRarity random(Random rand) {
        return LootRarity.random(rand, 0);
    }
}

