/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.init.ModItems;
import net.silentchaos512.supermultidrills.item.DrillChassisItem;

public class ChassisColorRecipe
extends SpecialRecipe {
    public static final ResourceLocation NAME = SuperMultiDrills.getId("color_chassis");
    public static final Serializer SERIALIZER = new Serializer();

    public ChassisColorRecipe(ResourceLocation recipeId) {
        super(recipeId);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack chassis = list.uniqueMatch(ChassisColorRecipe::isDrillChassis);
        Collection dyes = list.allMatches(s -> ChassisColorRecipe.getDyeColor(s).isPresent());
        return !chassis.func_190926_b() && !dyes.isEmpty();
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack chassis = list.uniqueMatch(ChassisColorRecipe::isDrillChassis).func_77946_l();
        Collection dyes = list.allMatches(s -> ChassisColorRecipe.getDyeColor(s).isPresent());
        ChassisColorRecipe.applyDyes(chassis, dyes);
        return chassis;
    }

    private static boolean isDrillChassis(ItemStack stack) {
        return stack.func_77973_b() == ModItems.drillChassis;
    }

    private static void applyDyes(ItemStack chassis, Collection<ItemStack> dyes) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int currentColor = DrillChassisItem.getColor(chassis);
        if (currentColor != DyeColor.WHITE.func_196060_f()) {
            float r = (float)(currentColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(currentColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(currentColor & 0xFF) / 255.0f;
            maxColorSum = (int)((float)maxColorSum + Math.max(r, Math.max(g, b)) * 255.0f);
            componentSums[0] = (int)((float)componentSums[0] + r * 255.0f);
            componentSums[1] = (int)((float)componentSums[1] + g * 255.0f);
            componentSums[2] = (int)((float)componentSums[2] + b * 255.0f);
            ++colorCount;
        }
        for (ItemStack dye : dyes) {
            float[] componentValues = ChassisColorRecipe.getDyeColor(dye).orElse(DyeColor.WHITE).func_193349_f();
            int r = (int)(componentValues[0] * 255.0f);
            int g = (int)(componentValues[1] * 255.0f);
            int b = (int)(componentValues[2] * 255.0f);
            maxColorSum += Math.max(r, Math.max(g, b));
            componentSums[0] = componentSums[0] + r;
            componentSums[1] = componentSums[1] + g;
            componentSums[2] = componentSums[2] + b;
            ++colorCount;
        }
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = (float)maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            DrillChassisItem.setColor(chassis, finalColor);
        }
    }

    private static Optional<DyeColor> getDyeColor(ItemStack dye) {
        return Optional.ofNullable(DyeColor.getColor((ItemStack)dye));
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)ModItems.drillChassis);
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ChassisColorRecipe> {
        private Serializer() {
        }

        public ChassisColorRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new ChassisColorRecipe(recipeId);
        }

        public ChassisColorRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new ChassisColorRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, ChassisColorRecipe recipe) {
        }
    }
}

