/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.tile.BPTileEntityType;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TileBPMicroblock
extends TileEntity {
    public static final ModelProperty<Pair<Block, Integer>> PROPERTY_INFO = new ModelProperty();
    private Block block = Blocks.field_150348_b;
    private Integer rotation = 0;

    public TileBPMicroblock() {
        super(BPTileEntityType.MICROBLOCK);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(PROPERTY_INFO, (Object)new ImmutablePair((Object)this.block, (Object)this.rotation)).build();
    }

    public void setBlock(Block block) {
        this.block = block;
        this.requestModelDataUpdate();
        this.markDirtyClient();
    }

    public Block getBlock() {
        return this.block;
    }

    private void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("block", this.block.getRegistryName().toString());
        compound.func_74768_a("rotation", this.rotation.intValue());
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i("block")));
        this.rotation = compound.func_74762_e("block");
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager networkManager, SUpdateTileEntityPacket packet) {
        Block oldblock = this.getBlock();
        CompoundNBT tagCompound = packet.func_148857_g();
        super.onDataPacket(networkManager, packet);
        this.func_145839_a(tagCompound);
        if (this.field_145850_b.field_72995_K && !this.getBlock().equals(oldblock)) {
            this.field_145850_b.func_175646_b(this.func_174877_v(), this.getTileEntity());
        }
    }
}

