/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.equipment.bauble.ItemHolyCloak;

public class ItemUnholyCloak
extends ItemHolyCloak {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/cloak_unholy.png");
    private static final ResourceLocation textureGlow = new ResourceLocation("botania:textures/model/cloak_unholy_glow.png");

    public ItemUnholyCloak(Item.Properties props) {
        super(props);
    }

    @Override
    public boolean effectOnDamage(LivingHurtEvent event, PlayerEntity player, ItemStack stack) {
        if (!event.getSource().func_76363_c()) {
            int range = 6;
            List mobs = player.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(player.func_226277_ct_() - (double)range, player.func_226278_cu_() - (double)range, player.func_226281_cx_() - (double)range, player.func_226277_ct_() + (double)range, player.func_226278_cu_() + (double)range, player.func_226281_cx_() + (double)range), (Predicate)Predicates.instanceOf(IMob.class));
            for (IMob mob : mobs) {
                if (!(mob instanceof LivingEntity)) continue;
                LivingEntity entity = (LivingEntity)mob;
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), event.getAmount());
            }
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.unholyCloak, SoundCategory.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 90; ++i) {
                float rad = (float)i * 4.0f * (float)Math.PI / 180.0f;
                float xMotion = (float)Math.cos(rad) * 0.2f;
                float zMotion = (float)Math.sin(rad) * 0.2f;
                WispParticleData data = WispParticleData.wisp(0.6f + (float)Math.random() * 0.2f, 0.4f + (float)Math.random() + 0.25f, 0.0f, 0.0f);
                player.field_70170_p.func_195594_a((IParticleData)data, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), (double)xMotion, 0.0, (double)zMotion);
            }
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    ResourceLocation getCloakTexture() {
        return texture;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    ResourceLocation getCloakGlowTexture() {
        return textureGlow;
    }
}

