/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.IWrappedInventory;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.api.internal.DummyMethodHandler;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.subtile.functional.SubTileSolegnolia;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.integration.corporea.WrappedIInventory;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemLokiRing;

public class InternalMethodHandler
extends DummyMethodHandler {
    @Override
    public IManaNetwork getManaNetworkInstance() {
        return ManaNetworkHandler.instance;
    }

    @Override
    public IItemHandlerModifiable getAccessoriesInventory(PlayerEntity player) {
        if (Botania.curiosLoaded) {
            LazyOptional<IItemHandlerModifiable> cap = EquipmentHandler.getAllWorn((LivingEntity)player);
            return (IItemHandlerModifiable)cap.orElseGet(EmptyHandler::new);
        }
        return new EmptyHandler();
    }

    @Override
    public void drawSimpleManaHUD(int color, int mana, int maxMana, String name) {
        HUDHandler.drawSimpleManaHUD(color, mana, maxMana, name);
    }

    @Override
    public void drawComplexManaHUD(int color, int mana, int maxMana, String name, ItemStack bindDisplay, boolean properlyBound) {
        HUDHandler.drawComplexManaHUD(color, mana, maxMana, name, bindDisplay, properlyBound);
    }

    @Override
    public ItemStack getBindDisplayForFlowerType(TileEntitySpecialFlower e) {
        return e instanceof TileEntityGeneratingFlower ? new ItemStack((IItemProvider)ModBlocks.manaSpreader) : (e instanceof TileEntityFunctionalFlower ? new ItemStack((IItemProvider)ModBlocks.manaPool) : new ItemStack((IItemProvider)ModItems.twigWand));
    }

    @Override
    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float size, int m) {
        SparkleParticleData data = SparkleParticleData.sparkle(size, r, g, b, m);
        world.func_195594_a((IParticleData)data, x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public ResourceLocation getDefaultBossBarTexture() {
        return BossBarHandler.defaultBossBar;
    }

    @Override
    public boolean shouldForceCheck() {
        return (Boolean)ConfigHandler.COMMON.flowerForceCheck.get();
    }

    @Override
    public int getPassiveFlowerDecay() {
        return 72000;
    }

    @Override
    public void breakOnAllCursors(PlayerEntity player, Item item, ItemStack stack, BlockPos pos, Direction side) {
        ItemLokiRing.breakOnAllCursors(player, item, stack, pos, side);
    }

    @Override
    public boolean hasSolegnoliaAround(Entity e) {
        return SubTileSolegnolia.hasSolegnoliaAround(e);
    }

    @Override
    public long getWorldElapsedTicks() {
        return Botania.proxy.getWorldElapsedTicks();
    }

    @Override
    public List<IWrappedInventory> wrapInventory(List<InvWithLocation> inventories) {
        ArrayList<IWrappedInventory> arrayList = new ArrayList<IWrappedInventory>();
        for (InvWithLocation inv : inventories) {
            ICorporeaSpark spark = CorporeaHelper.instance().getSparkForInventory(inv);
            IWrappedInventory wrapped = null;
            if (wrapped == null) {
                wrapped = WrappedIInventory.wrap(inv, spark);
            }
            arrayList.add(wrapped);
        }
        return arrayList;
    }
}

