/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ElvenTradeProcessor
implements IComponentProcessor {
    private List<IElvenTradeRecipe> recipes;
    private int longestIngredientSize;
    private int mostInputs;
    private int mostOutputs;

    public void setup(IVariableProvider<String> variables) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String s : ((String)variables.get("recipes")).split(";")) {
            IRecipe recipe = (IRecipe)Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215366_a(ModRecipeTypes.ELVEN_TRADE_TYPE).get(new ResourceLocation(s));
            if (recipe instanceof IElvenTradeRecipe) {
                builder.add((Object)((IElvenTradeRecipe)recipe));
                continue;
            }
            Botania.LOGGER.warn("Missing elven trade recipe " + s);
        }
        this.recipes = builder.build();
        for (IElvenTradeRecipe recipe : this.recipes) {
            NonNullList<Ingredient> inputs = recipe.func_192400_c();
            for (Ingredient ingredient : inputs) {
                int length = ingredient.func_193365_a().length;
                if (length <= this.longestIngredientSize) continue;
                this.longestIngredientSize = length;
            }
            if (inputs.size() > this.mostInputs) {
                this.mostInputs = inputs.size();
            }
            if (recipe.getOutputs().size() <= this.mostOutputs) continue;
            this.mostOutputs = recipe.getOutputs().size();
        }
    }

    public String process(String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            return this.recipes.get(0).getOutputs().get(0).func_200301_q().getString();
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            if (index < this.mostInputs) {
                return this.interweaveIngredients(index);
            }
            return null;
        }
        if (key.startsWith("output")) {
            int index = Integer.parseInt(key.substring(6)) - 1;
            if (index < this.mostOutputs) {
                return this.recipes.stream().map(IElvenTradeRecipe::getOutputs).map(l -> index < l.size() ? (ItemStack)l.get(index) : ItemStack.field_190927_a).map(arg_0 -> ((PatchouliAPI.IPatchouliAPI)PatchouliAPI.instance).serializeItemStack(arg_0)).collect(Collectors.joining(","));
            }
            return null;
        }
        return null;
    }

    private String interweaveIngredients(int inputIndex) {
        List<Ingredient> recipes = this.recipes.stream().map(IElvenTradeRecipe::func_192400_c).map(ingredients -> {
            if (inputIndex < ingredients.size()) {
                return (Ingredient)ingredients.get(inputIndex);
            }
            return Ingredient.field_193370_a;
        }).collect(Collectors.toList());
        return PatchouliUtils.interweaveIngredients(recipes, this.longestIngredientSize);
    }
}

