/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.view;

import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IWorld;

@Immutable
public final class SimpleBuildContext
implements IBuildContext {
    @Nonnull
    private final IWorld world;
    @Nullable
    private final PlayerEntity buildingPlayer;
    private final ItemStack stack;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderOf(@Nullable IBuildContext context) {
        Builder builder = SimpleBuildContext.builder();
        if (context == null) {
            return builder;
        }
        return builder.world(context.getWorld()).buildingPlayer(context.getBuildingPlayer()).usedStack(context.getUsedStack());
    }

    public static SimpleBuildContext copyOf(@Nullable IBuildContext context) {
        return SimpleBuildContext.builderOf(context).build();
    }

    public SimpleBuildContext(@Nonnull IWorld world, @Nullable PlayerEntity buildingPlayer, @Nonnull ItemStack stack) {
        this.world = world;
        this.buildingPlayer = buildingPlayer;
        this.stack = stack;
    }

    @Override
    public IWorld getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public PlayerEntity getBuildingPlayer() {
        return this.buildingPlayer;
    }

    @Override
    public ItemStack getUsedStack() {
        return this.stack;
    }

    public static final class Builder {
        @Nullable
        private IWorld world = null;
        @Nullable
        private PlayerEntity buildingPlayer = null;
        @Nonnull
        private ItemStack stack = ItemStack.field_190927_a;

        private Builder() {
        }

        public Builder world(@Nonnull IWorld world) {
            this.world = world;
            return this;
        }

        public Builder buildingPlayer(@Nullable PlayerEntity buildingPlayer) {
            this.buildingPlayer = buildingPlayer;
            if (this.world == null && buildingPlayer != null) {
                this.world = buildingPlayer.field_70170_p;
            }
            return this;
        }

        public Builder usedStack(@Nonnull ItemStack stack) {
            this.stack = stack;
            return this;
        }

        public SimpleBuildContext build() {
            return this.build(null);
        }

        public SimpleBuildContext build(@Nullable IWorld world) {
            return new SimpleBuildContext(world != null ? world : Objects.requireNonNull(this.world), this.buildingPlayer, this.stack);
        }
    }
}

