/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client;

import com.direwolf20.buildinggadgets.client.screen.TemplateManagerGUI;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.registry.OurItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class BuildingGadgetsJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("buildinggadgets", "jei_plugin");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(TemplateManagerGUI.class, (IGuiContainerHandler)new GuiContainerHandler());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ArrayList<AbstractGadget> gadgets = new ArrayList<AbstractGadget>(){
            {
                this.add(OurItems.gadgetBuilding);
                this.add(OurItems.gadgetExchanger);
                this.add(OurItems.gadgetDestruction);
                this.add(OurItems.gadgetCopyPaste);
            }
        };
        for (AbstractGadget gadget : gadgets) {
            registration.registerSubtypeInterpreter((Item)gadget, itemStack -> {
                if (!(itemStack.func_77973_b() instanceof AbstractGadget)) {
                    return "";
                }
                double energy = itemStack.func_196082_o().func_74769_h("energy");
                if (energy == 0.0) {
                    return "empty";
                }
                if (energy == (double)((AbstractGadget)itemStack.func_77973_b()).getEnergyMax()) {
                    return "charged";
                }
                return "";
            });
        }
    }

    private static class GuiContainerHandler
    implements IGuiContainerHandler<TemplateManagerGUI> {
        private GuiContainerHandler() {
        }

        public List<Rectangle2d> getGuiExtraAreas(TemplateManagerGUI containerScreen) {
            return new ArrayList<Rectangle2d>(Collections.singleton(new Rectangle2d(containerScreen.width / 2 + 80, containerScreen.height / 2 - 80, 60, 120)));
        }
    }
}

