/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.mui.module;

import icyllis.modernui.gui.master.GlobalModuleManager;
import icyllis.modernui.gui.master.Icon;
import icyllis.modernui.gui.master.Module;
import icyllis.modernui.gui.master.ModuleGroup;
import icyllis.modernui.gui.math.DelayedRunnable;
import icyllis.modernui.gui.widget.TextIconButton;
import icyllis.modernui.system.ConstantsLibrary;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.client.mui.element.FluxBackground;
import sonar.fluxnetworks.client.mui.module.FluxTileHome;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class NavigationHome
extends ModuleGroup {
    private final IFluxNetwork network;
    private final List<TextIconButton> navigationButtons = new ArrayList<TextIconButton>();

    public NavigationHome(@Nonnull INetworkConnector connector) {
        this.network = FluxNetworkCache.instance.getClientNetwork(connector.getNetworkID());
        this.addDrawable(new FluxBackground(this));
        for (EnumNavigationTabs tab : EnumNavigationTabs.values()) {
            int i = tab.getId();
            Icon icon = new Icon(ConstantsLibrary.ICONS, (float)((i - 1) * 32) / 512.0f, 0.6875f, (float)(i * 32) / 512.0f, 0.75f, true);
            TextIconButton button = new TextIconButton((Module)this, tab.getTranslatedName(), 16.0f, 16.0f, icon, () -> this.switchChildModule(i), TextIconButton.Direction.UP);
            button.setId(i);
            this.navigationButtons.add(button);
        }
        this.navigationButtons.forEach(arg_0 -> ((NavigationHome)this).addWidget(arg_0));
        if (connector instanceof TileFluxCore) {
            this.addChildModule(EnumNavigationTabs.TAB_HOME.getId(), () -> new FluxTileHome((TileFluxCore)connector));
        }
        GlobalModuleManager.INSTANCE.scheduleRunnable(new DelayedRunnable(() -> this.switchChildModule(EnumNavigationTabs.TAB_HOME.getId()), 0));
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        int i = 0;
        float ny = (float)height / 2.0f - 95.0f;
        for (TextIconButton button : this.navigationButtons) {
            if (i == EnumNavigationTabs.TAB_CREATE.getId() - 1) {
                button.setPos((float)width / 2.0f + 60.0f, ny);
            } else {
                button.setPos((float)width / 2.0f - 76.0f + (float)(i * 18), ny);
            }
            ++i;
        }
    }

    protected void moduleChanged(int id) {
        super.moduleChanged(id);
        this.navigationButtons.forEach(e -> e.onModuleChanged(id));
    }

    public IFluxNetwork getNetwork() {
        return this.network;
    }
}

