/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.client.gui.LineChart;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.NetworkUpdateRequestPacket;
import sonar.fluxnetworks.common.registry.RegistryBlocks;

public class GuiTabStatistics
extends GuiTabCore {
    public InvisibleButton redirectButton;
    private NetworkStatistics stats;
    private LineChart chart;
    private int timer;
    private static CompoundNBT GUI_COLOR_TAG = new CompoundNBT();
    private static ItemStack plug;
    private static ItemStack point;
    private static ItemStack storage;
    private static ItemStack controller;

    public GuiTabStatistics(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        this.stats = this.network.getSetting(NetworkSettings.NETWORK_STATISTICS);
        this.timer = 0;
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_STATISTICS;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.networkValid) {
            int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR);
            this.screenUtils.renderNetwork(this.network.getSetting(NetworkSettings.NETWORK_NAME), color, 20, 8);
            this.font.func_211126_b(TextFormatting.GRAY + FluxTranslate.PLUGS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxPlugCount, 12.0f, 24.0f, color);
            this.font.func_211126_b(TextFormatting.GRAY + FluxTranslate.POINTS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxPointCount, 12.0f, 36.0f, color);
            this.font.func_211126_b(TextFormatting.GRAY + FluxTranslate.STORAGES.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxStorageCount, 82.0f, 24.0f, color);
            this.font.func_211126_b(TextFormatting.GRAY + FluxTranslate.CONTROLLERS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxControllerCount, 82.0f, 36.0f, color);
            this.font.func_211126_b(TextFormatting.GRAY + FluxTranslate.INPUT.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + FluxUtils.format(this.stats.energyInput, FluxUtils.TypeNumberFormat.COMPACT, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), true), 12.0f, 48.0f, color);
            this.font.func_211126_b(TextFormatting.GRAY + FluxTranslate.OUTPUT.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + FluxUtils.format(this.stats.energyOutput, FluxUtils.TypeNumberFormat.COMPACT, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), true), 12.0f, 60.0f, color);
            this.font.func_211126_b(TextFormatting.GRAY + FluxTranslate.BUFFER.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + FluxUtils.format(this.stats.totalBuffer, FluxUtils.TypeNumberFormat.COMPACT, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), false), 12.0f, 72.0f, color);
            this.font.func_211126_b(TextFormatting.GRAY + FluxTranslate.ENERGY.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + FluxUtils.format(this.stats.totalEnergy, FluxUtils.TypeNumberFormat.COMPACT, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), false), 12.0f, 84.0f, color);
            GlStateManager.func_227632_a_((double)0.75, (double)0.75, (double)0.75);
            this.drawCenteredString(this.font, FluxTranslate.AVERAGE_TICK.t() + ": " + this.stats.average_tick_micro + " \u00b5s/t", (int)((double)(this.field_146999_f / 2) * 1.3333333333333333), (int)((double)(this.field_147000_g - 2) * 1.3333333333333333), color);
            GlStateManager.func_227632_a_((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiTabStatistics.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
            this.addButton((Widget)this.redirectButton);
        }
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        if (this.networkValid && this.chart != null) {
            this.chart.drawChart(this.minecraft);
            this.chart.updateHeight(partialTicks);
        }
    }

    @Override
    public void init() {
        super.init();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_STATISTICS, this.navigationTabs);
        if (this.networkValid) {
            this.chart = new LineChart(this.width / 2 - 48, this.height / 2 + 20, 50, 6, "s", "RF");
            this.chart.updateData(this.stats.energyChange);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.networkValid) {
            if (this.timer == 0) {
                PacketHandler.INSTANCE.sendToServer((Object)new NetworkUpdateRequestPacket(this.network.getNetworkID(), NBTType.NETWORK_STATISTICS));
            }
            if (this.timer == 1) {
                this.chart.updateData(this.stats.energyChange);
            }
            ++this.timer;
            this.timer %= 20;
        }
    }

    static {
        GUI_COLOR_TAG.func_74757_a("GuiColor", true);
        plug = new ItemStack((IItemProvider)RegistryBlocks.FLUX_PLUG);
        plug.func_77982_d(GUI_COLOR_TAG);
        point = new ItemStack((IItemProvider)RegistryBlocks.FLUX_POINT);
        point.func_77982_d(GUI_COLOR_TAG);
        storage = new ItemStack((IItemProvider)RegistryBlocks.BASIC_FLUX_STORAGE);
        storage.func_77982_d(GUI_COLOR_TAG);
        controller = new ItemStack((IItemProvider)RegistryBlocks.FLUX_CONTROLLER);
        controller.func_77982_d(GUI_COLOR_TAG);
    }
}

