/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public final class StringHelper {
    private StringHelper() {
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    public static String localize(String key) {
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public static String localize(String key, Object ... format) {
        return I18n.func_135052_a((String)key, (Object[])format);
    }

    public static boolean canLocalize(String key) {
        return I18n.func_188566_a((String)key);
    }

    public static String format(long number) {
        return NumberFormat.getInstance().format(number);
    }

    public static ITextComponent getFluidName(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        ITextComponent name = fluid.getAttributes().getDisplayName(stack);
        switch (fluid.getAttributes().getRarity(stack)) {
            case UNCOMMON: {
                name.func_211708_a(TextFormatting.YELLOW);
                break;
            }
            case RARE: {
                name.func_211708_a(TextFormatting.AQUA);
                break;
            }
            case EPIC: {
                name.func_211708_a(TextFormatting.LIGHT_PURPLE);
            }
        }
        return name;
    }

    public static ITextComponent getItemName(ItemStack stack) {
        Item item = stack.func_77973_b();
        ITextComponent name = item.func_200295_i(stack);
        switch (item.func_77613_e(stack)) {
            case UNCOMMON: {
                name.func_211708_a(TextFormatting.YELLOW);
                break;
            }
            case RARE: {
                name.func_211708_a(TextFormatting.AQUA);
                break;
            }
            case EPIC: {
                name.func_211708_a(TextFormatting.LIGHT_PURPLE);
            }
        }
        return name;
    }

    public static String getScaledNumber(long number) {
        if (number >= 1000000000L) {
            return number / 1000000000L + "." + number % 1000000000L / 100000000L + number % 100000000L / 10000000L + "G";
        }
        if (number >= 1000000L) {
            return number / 1000000L + "." + number % 1000000L / 100000L + number % 100000L / 10000L + "M";
        }
        if (number >= 1000L) {
            return number / 1000L + "." + number % 1000L / 100L + number % 100L / 10L + "k";
        }
        return String.valueOf(number);
    }

    public static ITextComponent getChatComponent(Object object) {
        if (object instanceof ITextComponent) {
            return (ITextComponent)object;
        }
        if (object instanceof String) {
            return new StringTextComponent((String)object);
        }
        if (object instanceof ItemStack) {
            return ((ItemStack)object).func_151000_E();
        }
        if (object instanceof Entity) {
            return ((Entity)object).func_145748_c_();
        }
        return new StringTextComponent(String.valueOf(object));
    }

    public static ITextComponent formChatComponent(Object ... chats) {
        ITextComponent chat = StringHelper.getChatComponent(chats[0]);
        int chatsLength = chats.length;
        for (int i = 1; i < chatsLength; ++i) {
            chat.func_150257_a(StringHelper.getChatComponent(chats[i]));
        }
        return chat;
    }

    public static String toJSON(ITextComponent chatComponent) {
        return ITextComponent.Serializer.func_150696_a((ITextComponent)chatComponent);
    }

    public static ITextComponent fromJSON(String string) {
        return ITextComponent.Serializer.func_186877_b((String)string);
    }

    public static ITextComponent getEmptyLine() {
        return new StringTextComponent("");
    }

    public static ITextComponent getTextComponent(String key) {
        return StringHelper.canLocalize(key) ? new TranslationTextComponent(key, new Object[0]) : new StringTextComponent(key);
    }

    public static ITextComponent getInfoTextComponent(String key) {
        return StringHelper.getTextComponent(key).func_211708_a(TextFormatting.GREEN);
    }

    public static String[] decompose(String resourceLoc, char delimiter) {
        return StringHelper.decompose("minecraft", resourceLoc, delimiter);
    }

    public static String[] decompose(String modid, String resourceLoc, char delimiter) {
        String[] decomposed = new String[]{modid, resourceLoc};
        int delIndex = resourceLoc.indexOf(delimiter);
        if (delIndex >= 0) {
            decomposed[1] = resourceLoc.substring(delIndex + 1);
            if (delIndex >= 1) {
                decomposed[0] = resourceLoc.substring(0, delIndex);
            }
        }
        return decomposed;
    }

    public static String namespace(String resourceLoc) {
        return StringHelper.decompose(resourceLoc, ':')[0];
    }

    public static String path(String resourceLoc) {
        return StringHelper.decompose(resourceLoc, ':')[1];
    }
}

