/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import cofh.lib.util.helpers.SecurityHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;

public interface ISecurable {
    public AccessMode getAccess();

    public GameProfile getOwner();

    public void setAccess(AccessMode var1);

    public boolean setOwner(GameProfile var1);

    default public String getOwnerName() {
        return this.getOwner().getName();
    }

    default public boolean canAccess(PlayerEntity player) {
        return this.getAccess().matches(this.getOwner(), player);
    }

    default public boolean isSecurable() {
        return true;
    }

    default public boolean hasSecurity() {
        return !SecurityHelper.isDefaultProfile(this.getOwner());
    }

    public static enum AccessMode {
        PUBLIC,
        PRIVATE,
        FRIENDS,
        TEAM;

        public static final AccessMode[] VALUES;

        public boolean matches(GameProfile owner, PlayerEntity player) {
            UUID ownerID = owner.getId();
            if (SecurityHelper.isDefaultUUID(ownerID)) {
                return true;
            }
            UUID otherID = SecurityHelper.getID(player);
            switch (this) {
                case PUBLIC: {
                    return true;
                }
                case PRIVATE: 
                case FRIENDS: 
                case TEAM: {
                    return ownerID.equals(otherID);
                }
            }
            return true;
        }

        public boolean isPublic() {
            return this == PUBLIC;
        }

        public boolean isPrivate() {
            return this == PRIVATE;
        }

        public boolean isTeamOnly() {
            return this == TEAM;
        }

        public boolean isFriendsOnly() {
            return this == FRIENDS;
        }

        static {
            VALUES = AccessMode.values();
        }
    }
}

