/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.network.packet;

import cofh.lib.network.packet.IPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;

public interface IPacketClient
extends IPacket {
    public void handleClient();

    default public void sendToClients() {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        PlayerList list = server.func_184103_al();
        list.func_148540_a(this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    default public void sendToPlayer(ServerPlayerEntity player) {
        player.field_71135_a.func_147359_a(this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    default public void sendToDimension(DimensionType dim) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        PlayerList list = server.func_184103_al();
        list.func_148537_a(this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT), dim);
    }

    default public void sendToOps() {
        net.minecraft.network.IPacket<?> packet = null;
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        PlayerList playerList = server.func_184103_al();
        for (ServerPlayerEntity player : playerList.func_181057_v()) {
            if (!playerList.func_152596_g(player.func_146103_bH())) continue;
            if (packet == null) {
                packet = this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT);
            }
            player.field_71135_a.func_147359_a(packet);
        }
    }

    default public void sendToAllAround(BlockPos pos, double range, DimensionType dim) {
        this.sendToAllAround(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), range, dim);
    }

    default public void sendToAllAround(Vec3d pos, double range, DimensionType dim) {
        this.sendToAllAround(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, range, dim);
    }

    default public void sendToAllAround(double x, double y, double z, double range, DimensionType dim) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        PlayerList list = server.func_184103_al();
        list.func_148543_a(null, x, y, z, range, dim, this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    default public void sendToChunk(TileEntity tile) {
        this.sendToChunk((ServerWorld)tile.func_145831_w(), tile.func_174877_v());
    }

    default public void sendToChunk(ServerWorld world, BlockPos pos) {
        this.sendToChunk(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    default public void sendToChunk(ServerWorld world, int chunkX, int chunkZ) {
        this.sendToChunk(world, new ChunkPos(chunkX, chunkZ));
    }

    default public void sendToChunk(ServerWorld world, ChunkPos pos) {
        net.minecraft.network.IPacket<?> packet = this.toVanillaPacket(NetworkDirection.PLAY_TO_CLIENT);
        world.func_72863_F().field_217237_a.func_219097_a(pos, false).forEach(e -> e.field_71135_a.func_147359_a(packet));
    }
}

