/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.event;

import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryBowItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ArcheryHelper;
import cofh.lib.util.references.EnsorcellationReferences;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArcheryEvents {
    private static boolean registered = false;

    public static void register() {
        if (registered) {
            return;
        }
        MinecraftForge.EVENT_BUS.register(ArcheryEvents.class);
        registered = true;
    }

    private ArcheryEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleArrowLooseEvent(ArrowLooseEvent event) {
        ItemStack bow = event.getBow();
        if (!ArcheryHelper.validBow(bow)) {
            return;
        }
        PlayerEntity shooter = event.getPlayer();
        event.setCanceled(((IArcheryBowItem)bow.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).orElse((Object)CapabilityArchery.DEFAULT_BOW_CAPABILITY)).fireArrow(bow, ArcheryHelper.findAmmo(shooter), shooter, event.getCharge(), event.getWorld()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleArrowNockEvent(ArrowNockEvent event) {
        ItemStack bow = event.getBow();
        if (!ArcheryHelper.validBow(bow)) {
            return;
        }
        PlayerEntity shooter = event.getPlayer();
        ItemStack ammo = ArcheryHelper.findAmmo(shooter);
        if (ammo.func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0) {
            ammo = new ItemStack((IItemProvider)Items.field_151032_g);
        }
        if (!ammo.func_190926_b()) {
            shooter.func_184598_c(event.getHand());
            event.setAction(new ActionResult(ActionResultType.SUCCESS, (Object)bow));
        } else if (!shooter.field_71075_bZ.field_75098_d) {
            event.setAction(new ActionResult(ActionResultType.FAIL, (Object)bow));
        }
    }

    @SubscribeEvent
    public static void handleItemUseTickEvent(LivingEntityUseItemEvent.Tick event) {
        int encQuickDraw = EnchantmentHelper.func_77506_a((Enchantment)EnsorcellationReferences.QUICK_DRAW, (ItemStack)event.getItem());
        if (encQuickDraw > 0 && event.getDuration() > event.getItem().func_77988_m() - 20) {
            event.setDuration(event.getDuration() - encQuickDraw);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        int encVolley;
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = event.getSource().func_76346_g();
        if (entity instanceof IProjectile) {
            return;
        }
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        if (source.field_76373_n.equals("arrow") && (encVolley = Utils.getHeldEnchantmentLevel((LivingEntity)attacker, EnsorcellationReferences.VOLLEY)) > 0) {
            entity.field_70172_ad = 0;
        }
    }
}

