/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.energy;

import cofh.lib.capability.templates.EnchantableItem;
import cofh.lib.energy.IEnergyContainerItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyEnchantableItemWrapper
extends EnchantableItem
implements IEnergyStorage,
ICapabilityProvider {
    private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this);
    final ItemStack container;
    final IEnergyContainerItem item;
    final boolean canExtract;
    final boolean canReceive;

    public EnergyEnchantableItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn, boolean extractIn, boolean receiveIn, List<Enchantment> enchantments) {
        super(enchantments);
        this.container = containerIn;
        this.item = itemIn;
        this.canExtract = extractIn;
        this.canReceive = receiveIn;
    }

    public EnergyEnchantableItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn, List<Enchantment> enchantments) {
        this(containerIn, itemIn, true, true, enchantments);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return this.item.receiveEnergy(this.container, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        return this.item.extractEnergy(this.container, maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.item.getEnergyStored(this.container);
    }

    public int getMaxEnergyStored() {
        return this.item.getMaxEnergyStored(this.container);
    }

    public boolean canExtract() {
        return this.canExtract;
    }

    public boolean canReceive() {
        return this.canReceive;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }
}

