/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.capability.templates;

import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryBowItem;
import cofh.lib.util.helpers.MathHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ArcheryBowItem
implements IArcheryBowItem,
ICapabilityProvider {
    private final LazyOptional<IArcheryBowItem> holder = LazyOptional.of(() -> this);
    private final float accuracyModifier;
    private final float damageModifier;
    private final float velocityModifier;

    public ArcheryBowItem() {
        this.accuracyModifier = 1.0f;
        this.damageModifier = 1.0f;
        this.velocityModifier = 1.0f;
    }

    public ArcheryBowItem(float accuracyModifier, float damageModifier, float velocityModifier) {
        this.accuracyModifier = MathHelper.clamp(accuracyModifier, 0.1f, 10.0f);
        this.damageModifier = MathHelper.clamp(damageModifier, 0.1f, 10.0f);
        this.velocityModifier = MathHelper.clamp(velocityModifier, 0.1f, 10.0f);
    }

    @Override
    public float getAccuracyModifier(ItemStack bow, ItemStack ammo, PlayerEntity shooter) {
        return this.accuracyModifier;
    }

    @Override
    public float getDamageModifier(ItemStack bow, ItemStack ammo, PlayerEntity shooter) {
        return this.damageModifier;
    }

    @Override
    public float getVelocityModifier(ItemStack bow, ItemStack ammo, PlayerEntity shooter) {
        return this.velocityModifier;
    }

    @Override
    public void onArrowLoosed(ItemStack weapon, ItemStack ammo, PlayerEntity shooter) {
        weapon.func_222118_a(1, (LivingEntity)shooter, consumer -> consumer.func_213334_d(shooter.func_184600_cs()));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityArchery.BOW_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

