/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.vsngamer.elevatorid.ElevatorModTab;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.network.NetworkHandler;
import xyz.vsngamer.elevatorid.network.client.RemoveCamoPacket;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;
import xyz.vsngamer.elevatorid.util.FakeUseContext;

public class ElevatorBlock
extends HorizontalBlock {
    public static final BooleanProperty DIRECTIONAL = BooleanProperty.func_177716_a((String)"directional");
    public static final BooleanProperty SHOW_ARROW = BooleanProperty.func_177716_a((String)"show_arrow");
    private ElevatorBlockItem item;
    private DyeColor dyeColor;

    public ElevatorBlock(DyeColor color) {
        super(Block.Properties.func_200952_a((Material)Material.field_151580_n, (DyeColor)color).func_200947_a(SoundType.field_185854_g).func_200943_b(0.8f).func_208770_d().func_226896_b_());
        this.setRegistryName("elevatorid", "elevator_" + color.func_176610_l());
        this.dyeColor = color;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, DIRECTIONAL, SHOW_ARROW});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)DIRECTIONAL, (Comparable)Boolean.valueOf(false));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ElevatorTileEntity();
    }

    public boolean func_196253_a(BlockState state, @Nonnull BlockItemUseContext useContext) {
        return false;
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Block handBlock;
        BlockState stateToApply;
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack handStack = player.func_184586_b(handIn);
        ElevatorTileEntity tile = this.getElevatorTile((IBlockReader)worldIn, pos);
        if (tile == null) {
            return ActionResultType.FAIL;
        }
        if (this.isValidItem(handStack) && (stateToApply = (handBlock = Block.func_149634_a((Item)handStack.func_77973_b())).func_196258_a((BlockItemUseContext)new FakeUseContext(player, handIn, hit))) != tile.getHeldState()) {
            this.setCamoAndUpdate(stateToApply, tile, worldIn);
            return ActionResultType.SUCCESS;
        }
        if (player.func_213453_ef() && tile.getHeldState() != null) {
            NetworkHandler.INSTANCE.sendToServer((Object)new RemoveCamoPacket(pos));
            return ActionResultType.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tile, (BlockPos)pos);
        return ActionResultType.SUCCESS;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return (Boolean)ModConfig.GENERAL.mobSpawn.get() != false && super.canCreatureSpawn(state, world, pos, type, entityType);
    }

    public boolean func_220081_d(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_177230_c() instanceof BreakableBlock || super.func_200122_a(state, adjacentBlockState, side);
    }

    public boolean canBeConnectedTo(BlockState state, IBlockReader world, BlockPos pos, Direction facing) {
        ElevatorTileEntity tile = this.getElevatorTile(world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().canBeConnectedTo(world, pos, facing);
        }
        return super.canBeConnectedTo(state, world, pos, facing);
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, ISelectionContext context) {
        ElevatorTileEntity tile = this.getElevatorTile(worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().func_215685_b(worldIn, pos, context);
        }
        return super.func_220071_b(state, worldIn, pos, context);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        ElevatorTileEntity tile = this.getElevatorTile(worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().func_215700_a(worldIn, pos, context);
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        ElevatorTileEntity tile = this.getElevatorTile((IBlockReader)world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().getSlipperiness(world, pos, entity);
        }
        return super.getSlipperiness(state, world, pos, entity);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        ElevatorTileEntity tile = this.getElevatorTile((IBlockReader)worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            try {
                tile.getHeldState().func_177230_c().func_196262_a(state, worldIn, pos, entityIn);
                return;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public float func_226891_m_() {
        return super.func_226891_m_();
    }

    public float func_226892_n_() {
        return super.func_226892_n_();
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState updatedState;
        ElevatorTileEntity tile;
        if (!worldIn.func_201670_d() && (tile = this.getElevatorTile((IBlockReader)worldIn, currentPos)) != null && tile.getHeldState() != null && (updatedState = tile.getHeldState().func_196956_a(facing, facingState, worldIn, currentPos, facingPos)) != tile.getHeldState()) {
            tile.setHeldState(updatedState);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        ElevatorTileEntity tile = this.getElevatorTile(world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().canConnectRedstone(world, pos, side);
        }
        return false;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        ElevatorTileEntity tile = this.getElevatorTile((IBlockReader)world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().shouldCheckWeakPower(world, pos, side);
        }
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader reader, BlockPos pos, Direction direction) {
        ElevatorTileEntity tile = this.getElevatorTile(reader, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().func_185911_a(reader, pos, direction);
        }
        return 0;
    }

    public int func_176211_b(BlockState state, IBlockReader reader, BlockPos pos, Direction direction) {
        ElevatorTileEntity tile = this.getElevatorTile(reader, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().func_185893_b(reader, pos, direction);
        }
        return 0;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        ElevatorTileEntity tile = this.getElevatorTile(world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    public boolean func_200123_i(BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos) {
        return true;
    }

    public float func_220080_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        ElevatorTileEntity tile = this.getElevatorTile(worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().func_215703_d(worldIn, pos);
        }
        return super.func_220080_a(state, worldIn, pos);
    }

    public int func_200011_d(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        ElevatorTileEntity tile = this.getElevatorTile(worldIn, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().func_200016_a(worldIn, pos);
        }
        return worldIn.func_201572_C();
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        ElevatorTileEntity tile = this.getElevatorTile((IBlockReader)world, pos);
        if (tile != null && tile.getHeldState() != null) {
            return tile.getHeldState().getSoundType(world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public DyeColor getColor() {
        return this.dyeColor;
    }

    private boolean isValidItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (stack.func_190926_b()) {
            return false;
        }
        if (!(item instanceof BlockItem)) {
            return false;
        }
        if (block instanceof ElevatorBlock) {
            return false;
        }
        if (block.func_176223_P().func_185901_i() != BlockRenderType.MODEL) {
            return false;
        }
        return block.func_176223_P().func_185904_a().func_76220_a();
    }

    private ElevatorTileEntity getElevatorTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ElevatorTileEntity && tile.func_200662_C().func_223045_a(world.func_180495_p(pos).func_177230_c())) {
            return (ElevatorTileEntity)tile;
        }
        return null;
    }

    private void setCamoAndUpdate(BlockState newState, ElevatorTileEntity tile, World world) {
        tile.setHeldState(newState);
        world.func_184133_a(null, tile.func_174877_v(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Nonnull
    public Item func_199767_j() {
        if (this.item == null) {
            this.item = new ElevatorBlockItem();
        }
        return this.item;
    }

    public class ElevatorBlockItem
    extends BlockItem {
        ElevatorBlockItem() {
            super((Block)ElevatorBlock.this, new Item.Properties().func_200916_a(ElevatorModTab.TAB));
            ResourceLocation name = ElevatorBlock.this.getRegistryName();
            if (name != null) {
                this.setRegistryName(name);
            }
        }
    }
}

