/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.libs;

import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.kit.Kit;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.classes.teleport.TeleportRequest;
import com.maciej916.maessentials.classes.teleport.TeleportSimple;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Teleport;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.io.FilenameUtils;

public class Methods {
    public static final SuggestionProvider<CommandSource> HOME_SUGGEST = (context, builder) -> ISuggestionProvider.func_197008_a((String[])DataManager.getPlayer(((CommandSource)context.getSource()).func_197035_h()).getHomeData().getHomes().keySet().toArray(new String[0]), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSource> WARP_SUGGEST = (context, builder) -> ISuggestionProvider.func_197008_a((String[])DataManager.getWarp().getWarps().keySet().toArray(new String[0]), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSource> KIT_SUGGEST = (context, builder) -> ISuggestionProvider.func_197008_a((String[])DataManager.getKit().getKits().keySet().toArray(new String[0]), (SuggestionsBuilder)builder);

    private static String getVersion() {
        Optional o = ModList.get().getModContainerById("ma-essentials");
        if (o.isPresent()) {
            return ((ModContainer)o.get()).getModInfo().getVersion().toString();
        }
        return "NONE";
    }

    public static boolean isDev() {
        String version = Methods.getVersion();
        return version.equals("NONE");
    }

    public static ArrayList<String> catalogFiles(String catalog) {
        File folder = new File(catalog);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> data = new ArrayList<String>();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                String name = FilenameUtils.removeExtension((String)listOfFiles[i].getName());
                data.add(name);
            }
        }
        return data;
    }

    public static FileReader loadFile(String catalog, String fileName) throws Exception {
        return new FileReader(catalog + fileName + ".json");
    }

    public static boolean fileExist(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static long currentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static boolean giveKit(ServerPlayerEntity player, Kit kit) {
        try {
            ArrayList<ItemStack> items = kit.getItems();
            for (ItemStack item : items) {
                player.field_71071_by.func_70441_a(item);
            }
            return true;
        }
        catch (Exception e) {
            player.func_145747_a((ITextComponent)Methods.formatText("kit.maessentials.parse_error", new Object[0]));
            return false;
        }
    }

    public static boolean simpleTeleport(ServerPlayerEntity player, Location location, String teleport, long delay) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (eslPlayer.getTemp().isTeleportActive()) {
            player.func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.active", new Object[0]));
            return false;
        }
        if (delay == 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.teleported", new Object[0]));
            Teleport.doTeleport(player, location, true, true);
            return true;
        }
        eslPlayer.getTemp().setTeleportActive(new Location(player));
        TeleportSimple tpS = new TeleportSimple(player, location, teleport, delay);
        Teleport.doSimpleTeleport(tpS);
        return true;
    }

    public static boolean requestTeleport(ServerPlayerEntity creator, ServerPlayerEntity player, ServerPlayerEntity target, long delay) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (eslPlayer.getTemp().isTeleportActive()) {
            player.func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.active", new Object[0]));
            return false;
        }
        TeleportRequest existTpR = Teleport.findRequest(creator, player, target);
        if (existTpR != null) {
            player.func_145747_a((ITextComponent)Methods.formatText("tpa.maessentials.exist", target.func_145748_c_()));
            return false;
        }
        TeleportRequest tpR = new TeleportRequest(creator, player, target, delay);
        Teleport.doRequetTeleport(tpR);
        return true;
    }

    static boolean checkLocation(Location first, Location second) {
        return first.x == second.x && first.y == second.y && first.z == second.z && first.dimension == second.dimension;
    }

    static boolean checkDetailedLocation(Location first, Location second) {
        return first.x == second.x && first.y == second.y && first.z == second.z && first.dimension == second.dimension && first.rotationPitch == second.rotationPitch && first.rotationYaw == second.rotationYaw;
    }

    public static TextComponent formatText(String translationKey, Object ... args) {
        return new TranslationTextComponent(translationKey, args);
    }

    static void kickPlayer(ServerPlayerEntity player, StringTextComponent op, String reason) {
        player.field_71133_b.func_184103_al().func_148539_a((ITextComponent)Methods.formatText("kick.maessentials.done", player.func_145748_c_(), op, reason));
        player.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent(reason));
    }
}

