/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.events;

import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.kit.Kit;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.classes.player.PlayerRestriction;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Log;
import com.maciej916.maessentials.libs.Methods;
import com.maciej916.maessentials.libs.Teleport;
import com.maciej916.maessentials.libs.Time;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EventPlayerLoggedIn {
    public static void event(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        EssentialPlayer eslPlayer = DataManager.newPlayer(player);
        if (eslPlayer != null) {
            Kit kit;
            Location spawnLocation;
            Log.debug("New player " + player.func_145748_c_().getString() + " joined");
            if (player.func_184102_h().func_71262_S() && (spawnLocation = DataManager.getWorld().getSpawn()) != null) {
                Teleport.doTeleport(player, spawnLocation, true, false);
            }
            if (ConfigValues.kits_starting.booleanValue() && Methods.giveKit(player, kit = DataManager.getKit().getKit(ConfigValues.kits_starting_name))) {
                eslPlayer.getUsage().setKitUssage(ConfigValues.kits_starting_name);
                eslPlayer.saveData();
            }
        } else {
            EssentialPlayer eslPlayerExisted = DataManager.getPlayer(player);
            PlayerRestriction ban = eslPlayerExisted.getRestrictions().getBan();
            if (ban != null) {
                if (ban.getTime() == -1L) {
                    player.field_71135_a.func_194028_b((ITextComponent)Methods.formatText("tempban.maessentials.success.perm.target", player.func_145748_c_(), ban.getReason()));
                } else if (ban.getTime() > Methods.currentTimestamp()) {
                    String displayTime = Time.formatDate(ban.getTime() - Methods.currentTimestamp());
                    player.field_71135_a.func_194028_b((ITextComponent)Methods.formatText("tempban.maessentials.success.target", player.func_145748_c_(), displayTime, ban.getReason()));
                }
            }
            Log.debug("Player " + player.func_145748_c_().getString() + " joined");
        }
        EssentialPlayer eslPlayerNew = DataManager.getPlayer(player);
        eslPlayerNew.setUsername(player.func_145748_c_().getString());
        eslPlayerNew.saveData();
    }
}

