/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class CommandSpawn {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"spawn").requires(source -> source.func_197034_c(0));
        builder.executes(context -> CommandSpawn.spawn((CommandContext<CommandSource>)context));
        dispatcher.register(builder);
    }

    private static int spawn(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("spawn", ConfigValues.spawn_cooldown.intValue());
        if (cooldown != 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("maessentials.cooldown.teleport", cooldown));
            return 1;
        }
        eslPlayer.getUsage().setCommandUsage("spawn");
        eslPlayer.saveData();
        Location location = DataManager.getWorld().getSpawn();
        if (Methods.simpleTeleport(player, location, "spawn", ConfigValues.spawn_delay.intValue())) {
            if (ConfigValues.spawn_delay == 0) {
                player.func_145747_a((ITextComponent)Methods.formatText("spawn.maessentials.success", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)Methods.formatText("spawn.maessentials.success.wait", ConfigValues.spawn_delay));
            }
        }
        return 1;
    }
}

